/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting;

import agorum.commons.cache.GenericCache;
import agorum.commons.statistic.CoreStatistic;
import agorum.roi.common.utils.Beans;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.scripting.Cache;
import agorum.roi.scripting.Converter;
import agorum.roi.scripting.Engine;
import agorum.roi.scripting.EngineFactory;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class EngineContext {
    private static final String[] EXEC = new String[]{"require", "exec"};
    protected final boolean sandboxed;
    protected final SessionController sessionController;
    private Engine engine;
    private final Map<String, ContentInterface> resolved = new HashMap<String, ContentInterface>();
    private static final Cache<Script> scriptCache = new Cache();

    public EngineContext(boolean sandboxed, SessionController sessionController) {
        this.sandboxed = sandboxed;
        this.sessionController = sessionController;
    }

    @Deprecated
    public void release() {
    }

    public Object eval(String source) {
        return this.eval(source, null, null, false);
    }

    public Object eval(String source, String name) {
        return this.eval(source, name, null, false);
    }

    public Object eval(String source, String name, Map<? extends String, Object> map) {
        return this.eval(source, name, map, false);
    }

    public Object eval(String source, String name, boolean internal) {
        return this.eval(source, name, null, internal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String source, String name, Map<? extends String, Object> map, boolean internal) {
        Engine engine = this.getEngine();
        this.pre();
        try {
            Object object = engine.eval(source, name, map, internal);
            return object;
        }
        finally {
            this.post();
        }
    }

    public CompiledScript compile(String source, String name) {
        return new CompiledScript(this.getEngine().compile(source, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(CompiledScript script) {
        Engine engine = this.getEngine();
        this.pre();
        try {
            Object object = engine.exec(script.script, null, false);
            return object;
        }
        finally {
            this.post();
        }
    }

    public Object exec(String path, FolderObjectClientBean baseFolder) throws Exception {
        ContentInterface ci = this.findScript(path, baseFolder);
        if (ci == null) {
            throw new Exception("Could not find script: " + path);
        }
        return this.exec(ci, null, false);
    }

    public Object exec(ContentInterface ci) throws Exception {
        return this.exec(ci, null, false);
    }

    public Object exec(ContentInterface ci, Map<? extends String, Object> map) throws Exception {
        this.resolved.put(ci.getId().toString(), ci);
        return this.getEngine().call(EXEC, ci, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object exec(ContentInterface ci, Scriptable scope, boolean internal) throws Exception {
        Engine engine = this.getEngine();
        Script script = scriptCache.get(ci);
        if (script == null) {
            script = scriptCache.put(ci, () -> engine.compile(new InputStreamReader(ci.getContentStream(), StandardCharsets.UTF_8), ci.getName()));
        }
        if (!internal) {
            this.resolved.put("main", ci);
        }
        this.resolved.put(ci.getId().toString(), ci);
        this.pre();
        try {
            Object object = engine.exec(script, scope, internal);
            return object;
        }
        finally {
            this.post();
        }
    }

    public Object toJs(Object obj) {
        return this.getEngine().toJs(obj);
    }

    public Object toJava(Object obj) {
        return this.getEngine().toJava(obj);
    }

    public static Object getValue(Exception e) {
        if (e instanceof JavaScriptException) {
            return ((JavaScriptException)e).getValue();
        }
        return null;
    }

    protected Engine getEngine() {
        if (this.engine == null) {
            this.initializeEngine();
        }
        return this.engine;
    }

    protected void initializeEngine() {
        HashMap<String, BaseFunction> builtins = new HashMap<String, BaseFunction>();
        builtins.put("resolve", new BaseFunction(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length == 1) {
                    return EngineContext.this.resolve(args[0].toString(), null);
                }
                if (args.length == 2) {
                    return EngineContext.this.resolve(args[0].toString(), args[1].toString());
                }
                throw new EvaluatorException("resolve expects one or two arguments");
            }

            @Override
            public int getArity() {
                return 1;
            }
        });
        builtins.put("exec", new BaseFunction(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length == 1 || args.length == 2) {
                    ContentInterface ci;
                    Object script = Converter.toJava(args[0]);
                    if (script instanceof ContentInterface) {
                        ci = (ContentInterface)script;
                    } else if (script != null) {
                        ci = (ContentInterface)Beans.lookup(EngineContext.this.sessionController, script.toString());
                    } else {
                        throw new EvaluatorException("exec expects a script ID or object as its first parameter");
                    }
                    try {
                        return EngineContext.this.exec(ci, (Scriptable)args[1], true);
                    }
                    catch (Exception e) {
                        throw Context.throwAsScriptRuntimeEx(e);
                    }
                }
                throw new EvaluatorException("exec expects one or two arguments");
            }

            @Override
            public int getArity() {
                return 1;
            }
        });
        this.engine = EngineFactory.getEngine(this.sandboxed, builtins);
    }

    private String resolve(String path, String parentId) {
        try {
            ContentInterface ci;
            ContentInterface parent = this.resolved.get(parentId);
            FolderObjectClientBean baseFolder = null;
            if (parent instanceof GlobalObjectClientBean) {
                baseFolder = ((GlobalObjectClientBean)((Object)parent)).getFirstParent();
            }
            if ((ci = this.findScript(path, baseFolder)) == null) {
                throw new EvaluatorException("Could not resolve " + path + " below " + parentId);
            }
            String id = ci.getId().toString();
            this.resolved.put(id, ci);
            return id;
        }
        catch (Exception e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    private ContentInterface findScript(String path, FolderObjectClientBean baseFolder) throws Exception {
        if ((path = path.toLowerCase()).startsWith("./") || path.startsWith("../")) {
            if (baseFolder == null) {
                throw new IllegalArgumentException("No base folder found");
            }
            return this.findScriptInternal(path, baseFolder, false);
        }
        if (path.startsWith("/")) {
            return this.findScriptInternal(path, null, false);
        }
        return this.findScriptInternal("/agorum/roi/Scripting/Libraries/" + path, null, false);
    }

    private ContentInterface findScriptInternal(String path, FolderObjectClientBean baseFolder, boolean noCache) throws Exception {
        if (path.endsWith(".js")) {
            return this.tryFind(path, baseFolder, noCache);
        }
        ContentInterface script = this.tryFind(path + ".js", baseFolder, noCache);
        if (script == null) {
            script = this.tryFind(path + "/index.js", baseFolder, noCache);
        }
        if (script == null && !noCache) {
            return this.findScriptInternal(path, baseFolder, true);
        }
        return script;
    }

    private ContentInterface tryFind(String path, FolderObjectClientBean baseFolder, boolean noCache) throws Exception {
        Long id;
        GenericCache gc = GenericCache.getInstance((Object)EngineContext.class.getName(), (int)Integer.MAX_VALUE, (int)600000, (int)600000);
        String cacheKey = baseFolder + "/" + path;
        Long l = id = noCache ? null : (Long)gc.get((Object)cacheKey);
        if (id == null) {
            ContentInterface result = baseFolder == null ? (ContentInterface)((Object)this.sessionController.findGlobalObjectByPath(path)) : (ContentInterface)((Object)this.sessionController.findGlobalObjectByPath(baseFolder, path));
            if (result != null) {
                gc.put((Object)cacheKey, (Object)result.getId());
            }
            return result;
        }
        try {
            return (ContentInterface)((Object)this.sessionController.getGlobalObjectById(id));
        }
        catch (Exception e) {
            CoreStatistic.getInstance().warning((Throwable)e, "Script cache lookup failure");
            return this.tryFind(path, baseFolder, true);
        }
    }

    public Object get(String key) {
        return this.getEngine().get(key);
    }

    public Object remove(String key) {
        return this.getEngine().remove(key);
    }

    public Object put(String key, Object value) {
        return this.getEngine().put(key, value);
    }

    public void putAll(Map<? extends String, ?> m) {
        this.getEngine().putAll(m);
    }

    protected void pre() {
    }

    protected void post() {
    }

    public static class CompiledScript {
        private final Script script;

        private CompiledScript(Script script) {
            this.script = script;
        }
    }
}

