/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting;

import agorum.roi.ejb.common.SessionController;
import agorum.roi.scripting.Engine;
import agorum.roi.scripting.EngineContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;

public class NestedEngineContext
extends EngineContext
implements Map<String, Object> {
    private NestedEngineContext superContext;
    private final Map<String, Object> bindings = new HashMap<String, Object>();
    private List<String> injected;
    private int depth;

    public NestedEngineContext(boolean sandboxed, SessionController sessionController) {
        super(sandboxed, sessionController);
    }

    protected NestedEngineContext(NestedEngineContext superContext) {
        super(superContext.sandboxed, superContext.sessionController);
        this.superContext = superContext;
    }

    public NestedEngineContext subContext() {
        return new NestedEngineContext(this);
    }

    public NestedEngineContext subContext(String key) {
        return this.subContext(key, false);
    }

    public NestedEngineContext subContext(String key, boolean array) {
        NestedEngineContext subContext = this.subContext();
        if (array) {
            ArrayList binding = this.bindings.get(key);
            if (!(binding instanceof List)) {
                binding = new ArrayList();
                this.bindings.put(key, binding);
            }
            ((List)binding).add(subContext);
        } else {
            this.bindings.put(key, subContext);
        }
        return subContext;
    }

    @Override
    protected Engine getEngine() {
        if (this.superContext == null) {
            return super.getEngine();
        }
        return this.superContext.getEngine();
    }

    @Override
    public void clear() {
        this.bindings.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.bindings.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.bindings.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.bindings.get(key);
    }

    @Override
    public Object remove(Object key) {
        return this.bindings.remove(key);
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    @Override
    public Object put(String key, Object value) {
        return this.bindings.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.bindings.putAll(m);
    }

    @Override
    public Set<String> keySet() {
        return this.bindings.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.bindings.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.bindings.entrySet();
    }

    @Override
    protected void pre() {
        if (++this.depth > 1) {
            return;
        }
        Context.enter();
        this.injected = new ArrayList<String>();
        this.initializeBindings(this);
    }

    @Override
    protected void post() {
        if (--this.depth > 0) {
            return;
        }
        try {
            for (String key : this.injected) {
                super.remove(key);
            }
        }
        finally {
            Context.exit();
        }
    }

    private void initializeBindings(NestedEngineContext context) {
        if (context.superContext != null) {
            this.initializeBindings(context.superContext);
        }
        for (Map.Entry<String, Object> entry : context.bindings.entrySet()) {
            String key = entry.getKey();
            super.put(key, entry.getValue());
            this.injected.add(key);
        }
    }
}

