/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting.sandbox;

import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.scripting.sandbox.SandboxContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.mozilla.javascript.ClassShutter;

public class SandboxClassShutter
implements ClassShutter {
    private final SandboxContext context;
    private final List<Pattern> whitelist = new ArrayList<Pattern>();
    private final List<Pattern> blacklist = new ArrayList<Pattern>();

    public SandboxClassShutter(SandboxContext context, SessionController sc) throws Exception {
        this.context = context;
        String[] whiteListArr = MetaDbSuperCache.getSimplePropertyValues(sc, "MAIN_MODULE_MANAGEMENT/roi/control/scripting/security/Whitelist");
        String[] blackListArr = MetaDbSuperCache.getSimplePropertyValues(sc, "MAIN_MODULE_MANAGEMENT/roi/control/scripting/security/Blacklist");
        if (whiteListArr != null) {
            for (String entry : whiteListArr) {
                this.whitelist.add(Pattern.compile(entry));
            }
        }
        if (blackListArr != null) {
            for (String entry : blackListArr) {
                this.blacklist.add(Pattern.compile(entry));
            }
        }
    }

    @Override
    public boolean visibleToScripts(String className) {
        if (!this.context.isSandboxed()) {
            return true;
        }
        for (Pattern pattern : this.blacklist) {
            if (!pattern.matcher(className).matches()) continue;
            return false;
        }
        for (Pattern pattern : this.whitelist) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }
}

