/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting.sandbox;

import agorum.roi.scripting.sandbox.SandboxContext;
import agorum.roi.scripting.sandbox.SandboxNativeJavaObject;
import java.util.List;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class SandboxNativeList
extends SandboxNativeJavaObject {
    private static final long serialVersionUID = 1L;
    private final List<Object> list;

    public SandboxNativeList(SandboxContext context, Scriptable scope, List<Object> list, Class<?> staticType) {
        super(context, scope, list, staticType);
        this.list = list;
        this.prototype = ScriptableObject.getArrayPrototype(scope);
    }

    @Override
    public Object unwrap() {
        return this.list;
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    public Object get(String name, Scriptable start) {
        switch (name) {
            case "toString": 
            case "forEach": 
            case "sort": {
                return this.prototype.get(name, start);
            }
            case "length": {
                return this.list.size();
            }
        }
        try {
            int index = Integer.parseInt(name);
            Object value = this.get(index, start);
            if (value != null) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return super.get(name, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.list.size()) {
            return this.toJs(this.list.get(index), start);
        }
        return null;
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (this.tryHas(name)) {
            return true;
        }
        return super.has(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.tryHas(index)) {
            return true;
        }
        return super.has(index, start);
    }

    private boolean tryHas(String name) {
        try {
            return this.tryHas(Integer.parseInt(name));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean tryHas(int index) {
        return index >= 0 && index < this.list.size();
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        this.put(Integer.parseInt(name), start, value);
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        while (index >= this.list.size()) {
            this.list.add(null);
        }
        this.list.set(index, value);
    }

    @Override
    public void delete(String name) {
        this.delete(Integer.parseInt(name));
    }

    @Override
    public void delete(int index) {
        this.list.set(index, null);
    }

    @Override
    public Object[] getIds() {
        int len = this.list.size();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = i;
        }
        return result;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        return ScriptableObject.getDefaultValue(this, hint);
    }

    @Override
    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        return List.class.isInstance(((Wrapper)((Object)value)).unwrap());
    }
}

