/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.search;

import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.DataBaseObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import agorum.roi.ejb.interfaces.home.SearchHome;
import agorum.roi.ejb.interfaces.remote.SearchRemote;
import agorum.roi.search.SearchResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class SearchLowLevel {
    private boolean setAccessSettings;
    private boolean setAdminAccessSettings;
    public static final int NOT = 0;
    protected static final String NOT_STR = "NOT";
    public static final int AND = 1;
    protected static final String AND_STR = "AND";
    public static final int OR = 2;
    protected static final String OR_STR = "OR";
    public static final int NOP = 3;
    private static final String ALIASE_NAME = "roi_";
    public static final int SORTORDER_DESCENDING = 0;
    public static final int SORTORDER_LOWER_DESCENDING = 1;
    public static final int SORTORDER_ASCENDING = 2;
    public static final int SORTORDER_LOWER_ASCENDING = 3;
    public static final int EQUAL = 0;
    public static final int LESS_THAN = 1;
    public static final int LESS_THAN_EQUAL = 2;
    public static final int GREATER_THAN = 3;
    public static final int GREATER_THAN_EQUAL = 4;
    public static final int NOT_EQUAL = 5;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int LIKE = 8;
    public static final int NOT_LIKE = 9;
    public static final int IN = 10;
    public static final int NOT_IN = 11;
    public static final int DATE_COMP_YEAR = 0;
    public static final int DATE_COMP_MONTH = 1;
    public static final int DATE_COMP_DAY = 2;
    public static final int DATE_COMP_HOUR = 3;
    public static final int DATE_COMP_MIN = 4;
    public static final int DATE_COMP_SEC = 5;
    private SearchResultSet searchResultSet;
    private boolean withDeletor = true;
    public static final int OBJECTTYPE_ATTRIBUTE = 1;
    public static final int OBJECTTYPE_CONTENT = 2;
    public static final int OBJECTTYPE_SEARCHCLAUSE = 3;
    public static final int OBJECTTYPE_CLASSNAME = 4;
    public static final int OBJECTTYPE_JOIN = 5;
    public static final int OBJECTTYPE_CONTEXT = 6;
    public static final int OBJECTTYPE_SORTSPEZIFICATION = 7;
    public static final int OBJECTTYPE_ADDCLASSNAME_ALIAS = 8;
    public static final int OBJECTTYPE_DISTINCTSPEZIFICATION = 9;
    public static final int OBJECTTYPE_JOIN_POS = 10;
    public static final int OBJECTTYPE_SORTSPEZIFICATION_BYPOSITION = 11;
    public static final int OBJECTTYPE_ATTRIBUTE_POS = 12;
    public static final int OBJECTTYPE_NOTYPE = -1;
    public static int SEARCHCLAUSE_NOCLAUSE = -1;
    public static int QUALIFICATION_NOQUALIFICATION = -1;
    private String[] className;
    private String[] aliasClassName;
    private final Vector<SearchClassIntern> vSearch = new Vector();
    private int unionlevel;
    private Vector<String> whereStack = new Vector();
    private final Vector<String> whereStack2 = new Vector();
    private final Vector<String> joinStack = new Vector();
    private Map<String, String> aliasHash = new Hashtable<String, String>();
    private Vector<Object> bindAttributeValue = new Vector();
    private Vector<Object> bindAttributeValueFromSelect = new Vector();
    private String masterTable;
    private Hashtable<String, Object> columnsHash = new Hashtable();
    private StringBuffer select = new StringBuffer();
    private SearchRemote searchRemote;
    private final SessionController sessionController;
    private boolean countOnly;
    private boolean countOnlyNoAccess;
    private boolean onlyOneElement;
    private int limit = -1;
    private static Hashtable<String, StringBuffer> selectStatmentCache = new Hashtable();
    private SearchClassIntern distinctValues;
    private boolean isDistinct;

    public SearchLowLevel(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void addUnion() {
        ++this.unionlevel;
    }

    @Deprecated
    public void setBindOn() {
    }

    public void setCountOnly() {
        this.setCountOnly(false);
    }

    public void setWithDeletor(boolean withDeletor) {
        this.withDeletor = withDeletor;
    }

    public void setCountOnly(boolean flag) {
        this.countOnly = true;
        this.countOnlyNoAccess = flag;
    }

    public void setOnlyOneElement() {
        this.onlyOneElement = true;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setSortSpezification(String[] sClassnames, String[] sAttnames, int[] bOrders) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setSortClassnames(sClassnames);
        sci.setSortAttnames(sAttnames);
        sci.setSortOrders(bOrders);
        sci.setObjectType(7);
        this.vSearch.addElement(sci);
    }

    public void setSortSpezificationByPosition(String[] positions, int[] bOrders) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setSortClassnames(null);
        sci.setSortAttnames(positions);
        sci.setSortOrders(bOrders);
        sci.setObjectType(11);
        this.vSearch.addElement(sci);
    }

    public void setDistinctSpezification(String[] sDistinctClassnames, String[] sDistinctAttnames) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setDistinctClassnames(sDistinctClassnames);
        sci.setDistinctAttnames(sDistinctAttnames);
        sci.setObjectType(9);
        this.distinctValues = sci;
        this.isDistinct = true;
    }

    public void setClassname(String[] s) {
        this.setClassname(s, s, null, null);
    }

    public void setClassname(String[] s, String[] aliases) {
        this.setClassname(s, aliases, null, null);
    }

    public void setClassname(String[] s, String[] aliases, boolean[] delBehavior, boolean[] recBehavior) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setClassname(s);
        sci.setAliasClassname(aliases);
        sci.setObjectType(4);
        this.setWithDeletorAndSetAccessSettings(s);
        this.vSearch.addElement(sci);
    }

    public void addClassname(String classname, String alias) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setObjectType(8);
        this.vSearch.addElement(sci);
    }

    public void setSearchClause(int searchClause) {
        if (searchClause == 1) {
            this.setSearchClauseAND();
        } else if (searchClause == 2) {
            this.setSearchClauseOR();
        }
    }

    public void setSearchClauseAND() {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setSearchClause(1);
        sci.setObjectType(3);
        this.vSearch.addElement(sci);
    }

    public void setSearchClauseOR() {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setSearchClause(2);
        sci.setObjectType(3);
        this.vSearch.addElement(sci);
    }

    public void setJoin(String rightClassname, String rightAttribteName, String leftClassname, String leftAttribteName) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setRightAttributeClassname(rightClassname);
        sci.setRightAttributeName(rightAttribteName);
        sci.setLeftAttributeClassname(leftClassname);
        sci.setLeftAttributeName(leftAttribteName);
        sci.setObjectType(5);
        this.vSearch.addElement(sci);
    }

    public void setJoin(int rightClassnamePos, String rightAttribteName, int leftClassnamePos, String leftAttribteName) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setRightAttClassnamePos(new Integer(rightClassnamePos));
        sci.setRightAttributeName(rightAttribteName);
        sci.setLeftAttClassnamePos(new Integer(leftClassnamePos));
        sci.setLeftAttributeName(leftAttribteName);
        sci.setObjectType(10);
        this.vSearch.addElement(sci);
    }

    public void setAttribute(int attClassnamePos, String attName, Object attValue, boolean ignoreCase, int qualifire) {
        if (qualifire == 8) {
            this.setAttributeLIKE(attClassnamePos, attName, attValue, ignoreCase);
        } else if (qualifire == 9) {
            this.setAttributeNOT_LIKE(attClassnamePos, attName, attValue, ignoreCase);
        } else {
            this.setAttributeData(attClassnamePos, attName, attValue, qualifire, ignoreCase);
        }
    }

    public void setAttribute(String attClassname, String attName, Object attValue, boolean ignoreCase, int qualifire) {
        if (qualifire == 8) {
            this.setAttributeLIKE(attClassname, attName, attValue, ignoreCase);
        } else if (qualifire == 9) {
            this.setAttributeNOT_LIKE(attClassname, attName, attValue, ignoreCase);
        } else {
            this.setAttributeData(attClassname, attName, attValue, qualifire, ignoreCase);
        }
    }

    public void setAttributeEQUAL(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 0, ignoreCase);
    }

    public void setAttributeNOT_EQUAL(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 5, ignoreCase);
    }

    public void setAttributeNOT_IN(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 11, ignoreCase);
    }

    public void setAttributeIN(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 10, ignoreCase);
    }

    public void setAttributeDATE_COMP_DAY(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 2, ignoreCase);
    }

    public void setAttributeDATE_COMP_HOUR(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 3, ignoreCase);
    }

    public void setAttributeDATE_COMP_MIN(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 4, ignoreCase);
    }

    public void setAttributeDATE_COMP_MONTH(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 1, ignoreCase);
    }

    public void setAttributeDATE_COMP_SEC(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 5, ignoreCase);
    }

    public void setAttributeDATE_COMP_YEAR(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 0, ignoreCase);
    }

    public void setAttributeGREATER_THAN(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 3, ignoreCase);
    }

    public void setAttributeGREATER_THAN_EQUAL(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 4, ignoreCase);
    }

    public void setAttributeIS_NOT_NULL(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 7, ignoreCase);
    }

    public void setAttributeIS_NULL(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 6, ignoreCase);
    }

    public void setAttributeLESS_THAN(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 1, ignoreCase);
    }

    public void setAttributeLESS_THAN_EQUAL(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, attValue, 2, ignoreCase);
    }

    public void setAttributeLIKE(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, this.replaceWildeCards(attValue), 8, ignoreCase);
    }

    public void setAttributeNOT_LIKE(String attClassname, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassname, attName, this.replaceWildeCards(attValue), 9, ignoreCase);
    }

    public void setAttributeEQUAL(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 0, ignoreCase);
    }

    public void setAttributeNOT_EQUAL(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 5, ignoreCase);
    }

    public void setAttributeNOT_IN(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 11, ignoreCase);
    }

    public void setAttributeIN(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 10, ignoreCase);
    }

    public void setAttributeDATE_COMP_DAY(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 2, ignoreCase);
    }

    public void setAttributeDATE_COMP_HOUR(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 3, ignoreCase);
    }

    public void setAttributeDATE_COMP_MIN(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 4, ignoreCase);
    }

    public void setAttributeDATE_COMP_MONTH(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 1, ignoreCase);
    }

    public void setAttributeDATE_COMP_SEC(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 5, ignoreCase);
    }

    public void setAttributeDATE_COMP_YEAR(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 0, ignoreCase);
    }

    public void setAttributeGREATER_THAN(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 3, ignoreCase);
    }

    public void setAttributeGREATER_THAN_EQUAL(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 4, ignoreCase);
    }

    public void setAttributeIS_NOT_NULL(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 7, ignoreCase);
    }

    public void setAttributeIS_NULL(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 6, ignoreCase);
    }

    public void setAttributeLESS_THAN(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 1, ignoreCase);
    }

    public void setAttributeLESS_THAN_EQUAL(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, attValue, 2, ignoreCase);
    }

    public void setAttributeLIKE(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, this.replaceWildeCards(attValue), 8, ignoreCase);
    }

    public void setAttributeNOT_LIKE(int attClassnamePos, String attName, Object attValue, boolean ignoreCase) {
        this.setAttributeData(attClassnamePos, attName, this.replaceWildeCards(attValue), 9, ignoreCase);
    }

    private Object replaceWildeCards(Object attValue) {
        if (attValue instanceof String) {
            try {
                DatabaseUtils du = new DatabaseUtils();
                DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
                String s = (String)attValue;
                s = dbi.replaceWildCards(s);
                attValue = s;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attValue;
    }

    public void setAttributeData(String attClassname, String attName, Object attValue, int qual, boolean ignoreCase) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setAttributeQualification(qual);
        sci.setAttributeName(attName);
        sci.setAttributeValue(attValue);
        sci.setIgnoreCase(ignoreCase);
        sci.setObjectType(1);
        sci.setAttributeClassname(attClassname);
        if (attName.equalsIgnoreCase(GlobalObjectClientBean.DELETOR_ATTRIBUTE)) {
            this.withDeletor = false;
        }
        this.vSearch.addElement(sci);
    }

    public void setAttributeData(int attClassnamePos, String attName, Object attValue, int qual, boolean ignoreCase) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setAttributeQualification(qual);
        sci.setAttributeName(attName);
        sci.setAttributeValue(attValue);
        sci.setIgnoreCase(ignoreCase);
        sci.setObjectType(12);
        sci.setLeftAttClassnamePos(new Integer(attClassnamePos));
        if (attName.equalsIgnoreCase(GlobalObjectClientBean.DELETOR_ATTRIBUTE)) {
            this.withDeletor = false;
        }
        this.vSearch.addElement(sci);
    }

    public void setContext(String sWhere, String contectClassname) {
        SearchClassIntern sci = new SearchClassIntern(this.unionlevel);
        sci.setAttributeName(contectClassname);
        sci.setAttributeValue(sWhere);
        sci.setObjectType(6);
        this.vSearch.addElement(sci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setAgorumSearchObjectVector(String tableName, String searchName) throws Exception {
        this.whereStack = new Vector();
        this.aliasHash = new Hashtable<String, String>();
        this.columnsHash = new Hashtable();
        int aliasCounter = 0;
        String aliasName = ALIASE_NAME;
        this.masterTable = null;
        StringBuffer from = new StringBuffer();
        String sort = null;
        this.bindAttributeValue = new Vector();
        this.bindAttributeValueFromSelect = new Vector();
        this.select = new StringBuffer();
        if (searchName != null) {
            searchName = searchName + "_" + this.setAccessSettings + "_" + this.setAdminAccessSettings + "_" + this.withDeletor;
        }
        if (this.vSearch != null) {
            SearchClassIntern sci;
            int i;
            for (SearchClassIntern sciObj : this.vSearch) {
                Object attrValue;
                SearchClassIntern sci2 = sciObj;
                boolean ignoreCase = sci2.getIgnoreCase();
                if (!ignoreCase && (sci2.getObjectType() == 1 || sci2.getObjectType() == 12) && this.isCIColumn(sci2.getAttributeClassname(), sci2.getAttributeName())) {
                    ignoreCase = true;
                }
                if (!ignoreCase || !((attrValue = sci2.getAttributeValue()) instanceof String)) continue;
                sci2.setAttributeValue(((String)attrValue).toLowerCase(Locale.ROOT));
            }
            if (searchName != null && selectStatmentCache.containsKey(searchName)) {
                this.select = selectStatmentCache.get(searchName);
                int len = this.vSearch.size();
                int iOff = 0;
                for (int iUnion = 0; iUnion <= this.unionlevel; ++iUnion) {
                    block22: for (i = iOff; i < len; ++i) {
                        sci = this.vSearch.elementAt(i);
                        int myunionlevel = sci.getUnionlevel();
                        if (myunionlevel != iUnion) {
                            iOff = i - 1;
                            break;
                        }
                        switch (sci.getObjectType()) {
                            case 1: {
                                this.setAttributeQualificationOnly(sci, null);
                                continue block22;
                            }
                            case 12: {
                                this.setAttributeQualificationOnly(sci, null);
                            }
                        }
                    }
                    this.setBindVariables(this.setAccessSettings, this.setAdminAccessSettings, this.withDeletor);
                }
            } else {
                int len = this.vSearch.size();
                int iOff = 0;
                for (int iUnion = 0; iUnion <= this.unionlevel; ++iUnion) {
                    block24: for (i = iOff; i < len; ++i) {
                        sci = this.vSearch.elementAt(i);
                        int myunionlevel = sci.getUnionlevel();
                        if (myunionlevel != iUnion) {
                            iOff = i;
                            break;
                        }
                        switch (sci.getObjectType()) {
                            case 1: {
                                this.setAttributeQualification(sci);
                                continue block24;
                            }
                            case 12: {
                                this.setAttributeQualificationPos(sci);
                                continue block24;
                            }
                            case 5: {
                                this.setJoinQualification(sci);
                                continue block24;
                            }
                            case 10: {
                                this.setJoinQualificationPos(sci);
                                continue block24;
                            }
                            case 2: {
                                continue block24;
                            }
                            case 6: {
                                continue block24;
                            }
                            case 4: {
                                this.className = sci.getClassname();
                                this.aliasClassName = sci.getAliasClassname();
                                if (this.className == null) continue block24;
                                int lenT = this.className.length;
                                String trenn = "";
                                for (int x = 0; x < lenT; ++x) {
                                    if (x == 0) {
                                        this.masterTable = this.aliasClassName[x];
                                        Long classId = this.sessionController.getClassObject(this.className[x]).getId();
                                        Hashtable<String, Object> myAttributes = this.sessionController.getAllAttributesFromClassId(classId);
                                        Enumeration<String> attrEnum = myAttributes.keys();
                                        while (attrEnum.hasMoreElements()) {
                                            this.setColumn(this.masterTable, attrEnum.nextElement().toString());
                                        }
                                    }
                                    this.aliasHash.put(this.aliasClassName[x].toUpperCase(), aliasName + aliasCounter++);
                                    from.append(trenn);
                                    from.append(this.className[x]);
                                    from.append(" ");
                                    from.append(this.getAlias(this.aliasClassName[x].toUpperCase()));
                                    trenn = ",";
                                }
                                continue block24;
                            }
                            case 3: {
                                this.setSearchClause(sci);
                                continue block24;
                            }
                            case 8: {
                                System.err.println("OBJECTTYPE_ADDCLASSNAME_ALIAS not implements");
                                continue block24;
                            }
                            case 7: {
                                if (sci.getSortClassnames() == null || sci.getSortAttnames() == null || sci.getSortOrders() == null) continue block24;
                                sort = this.setSortSpecification(sci);
                                continue block24;
                            }
                            case 11: {
                                if (sci.getSortClassnames() != null || sci.getSortAttnames() == null || sci.getSortOrders() == null) continue block24;
                                sort = this.setSortSpecificationByPosition(sci);
                                continue block24;
                            }
                        }
                    }
                    if (iUnion > 0) {
                        this.select.append(" union ");
                    }
                    this.select.append("select ");
                    if (this.countOnly && this.unionlevel > 0) {
                        ExceptionUtils.handleException("count(*) and UNION not allowed", "agorum.roi.remote.exception.CountAndUnionNotAllowed", 78);
                    }
                    this.select.append(!this.countOnly ? this.getColumns() : " count(distinct(roi_0.ID)) ");
                    this.select.append(" from ");
                    this.select.append(from.toString());
                    from = new StringBuffer();
                    this.setAccessToSelect(this.setAccessSettings, this.setAdminAccessSettings, this.withDeletor, this.countOnly, this.isDistinct, sort);
                    this.setBindVariables(this.setAccessSettings, this.setAdminAccessSettings, this.withDeletor);
                    this.whereStack = new Vector();
                    this.aliasHash = new Hashtable<String, String>();
                    this.columnsHash = new Hashtable();
                    aliasCounter = 0;
                    this.masterTable = null;
                    from = new StringBuffer();
                }
                if (searchName != null) {
                    Hashtable<String, StringBuffer> hashtable = selectStatmentCache;
                    synchronized (hashtable) {
                        if (!selectStatmentCache.containsKey(searchName)) {
                            selectStatmentCache.put(searchName, this.select);
                        }
                    }
                }
            }
        }
        return this.select.toString();
    }

    private void setAccessToSelect(boolean lSetAccessSettings, boolean lSetAdminAccessSettings, boolean withDeletor, boolean countOnly, boolean isDistinct, String sort) throws Exception {
        if (lSetAccessSettings) {
            this.select.append(", ACLUSERTABLE roi_au, ACLOBJECTTABLE roi_aot");
        } else if (lSetAdminAccessSettings) {
            this.select.append(", ACLOBJECTTABLE roi_aot");
        }
        String w = " where ";
        if (withDeletor) {
            this.select.append(w);
            this.select.append("(roi_0.DELETOR=0 or roi_0.DELETOR =?)");
            w = " and ";
        }
        if (!this.whereStack.isEmpty()) {
            this.select.append(w);
            this.select.append("(");
            this.select.append(this.whereStack.elementAt(0));
            this.select.append(")");
            w = " and ";
            this.whereStack = new Vector();
        }
        if (lSetAccessSettings) {
            this.select.append(w);
            this.select.append("(");
            this.select.append("roi_aot.ACLID=roi_au.ACLID");
            this.select.append(" and ");
            this.select.append("roi_aot.OBJECTID = roi_0.ID");
            this.select.append(" and ");
            this.select.append(" (");
            this.select.append("(roi_0.OWNER=? and roi_au.USERID=0)");
            this.select.append(" or ");
            this.select.append("(");
            this.select.append("roi_0.OWNER != ?");
            this.select.append(" and ");
            this.select.append("roi_au.USERID=999");
            this.select.append(" and ");
            this.select.append("(select count(ACLID) from acluserrevoke where ");
            this.select.append("ACLID=roi_aot.ACLID and USERID=?)=0");
            this.select.append(")");
            this.select.append(" or ");
            this.select.append("(");
            this.select.append("roi_0.OWNER != ?");
            this.select.append(" and ");
            this.select.append("(roi_au.USERID=?)");
            this.select.append(")))");
            DatabaseUtils du = new DatabaseUtils();
            DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
            String groupBy = dbi.getDistinctByGroupBy();
            this.select.append(!countOnly ? (!isDistinct ? groupBy : "") : "");
            w = " and ";
        } else if (lSetAdminAccessSettings) {
            this.select.append(w);
            this.select.append("(");
            this.select.append("roi_aot.OBJECTID = roi_0.ID");
            this.select.append(" and ");
            this.select.append(" (");
            this.select.append("(roi_0.OWNER=?)");
            this.select.append(" or ");
            this.select.append("(");
            this.select.append("roi_0.OWNER != ?");
            this.select.append(" and ");
            this.select.append("(select count(ACLID) from acladminrevoke where ");
            this.select.append("ACLID=roi_aot.ACLID and USERID=?)=0");
            this.select.append(")");
            this.select.append(")");
            this.select.append(")");
            w = " and ";
        }
        if (sort != null && !countOnly && !this.onlyOneElement) {
            this.select.append(" order by ");
            this.select.append(sort);
        }
        if (this.onlyOneElement) {
            this.limit = 1;
        }
        if (this.limit >= 0) {
            String query = DatabaseUtils.getDatabaseInterface().limit(this.select.toString(), this.limit);
            this.select.setLength(0);
            this.select.append(query);
        }
    }

    private void setBindVariables(boolean lSetAccessSettings, boolean lSetAdminAccessSettings, boolean withDeletor) throws Exception {
        Long roleId;
        DirectoryUserObjectClientBean role = this.sessionController.getRole();
        DirectoryUserObjectClientBean user = this.sessionController.getLoginUser();
        Long userId = user == null ? new Long(0L) : user.getId();
        Long l = roleId = role == null ? new Long(0L) : role.getId();
        if (withDeletor) {
            this.bindAttributeValue.add(userId);
        }
        int lenBind = this.bindAttributeValueFromSelect.size();
        for (int iBind = 0; iBind < lenBind; ++iBind) {
            this.bindAttributeValue.add(this.bindAttributeValueFromSelect.get(iBind));
        }
        this.bindAttributeValueFromSelect = new Vector();
        if (lSetAccessSettings) {
            this.bindAttributeValue.add(userId);
            this.bindAttributeValue.add(userId);
            this.bindAttributeValue.add(roleId);
            this.bindAttributeValue.add(userId);
            this.bindAttributeValue.add(roleId);
        } else if (lSetAdminAccessSettings) {
            this.bindAttributeValue.add(userId);
            this.bindAttributeValue.add(userId);
            this.bindAttributeValue.add(roleId);
        }
    }

    private void setWithDeletorAndSetAccessSettings(String[] className) {
        if (className != null) {
            this.masterTable = className[0];
            this.setAccessSettings = !this.sessionController.getIsInLogin() && !this.sessionController.isAdminEnabled();
            this.setAdminAccessSettings = !this.sessionController.getIsInLogin() && !this.sessionController.isMainAdmin() && this.sessionController.isAdminEnabled();
            boolean isGlobalObject = this.masterTable.equalsIgnoreCase(GlobalObjectClientBean.CLASS_NAME);
            this.setAccessSettings = this.setAccessSettings && isGlobalObject;
            boolean bl = this.setAdminAccessSettings = this.setAdminAccessSettings && isGlobalObject;
            if (this.countOnly && (this.setAccessSettings || this.setAdminAccessSettings) && this.countOnlyNoAccess) {
                this.setAccessSettings = false;
                this.setAdminAccessSettings = false;
            }
            if (this.withDeletor && !isGlobalObject) {
                this.withDeletor = false;
            }
        }
    }

    private String getAlias(String key) {
        return this.aliasHash.get(key.toUpperCase()).toString();
    }

    private String getColumns() {
        StringBuffer columns = new StringBuffer();
        if (this.isDistinct && this.distinctValues != null) {
            columns.append("distinct ");
            String[] distinctClassnames = this.distinctValues.getDistinctClassnames();
            String[] distinctAttnames = this.distinctValues.getDistinctAttnames();
            int len = distinctClassnames.length;
            String trenn = "";
            for (int i = 0; i < len; ++i) {
                columns.append(trenn);
                columns.append(this.getAlias(distinctClassnames[i]));
                columns.append(".");
                columns.append(distinctAttnames[i]);
                trenn = ",";
            }
        } else {
            try {
                DatabaseUtils du = new DatabaseUtils();
                DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
                String distinct = dbi.getDistinct();
                if (distinct != null) {
                    columns.append(distinct);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            columns.append("");
            columns.append(this.getAlias(this.masterTable));
            columns.append(".");
            columns.append("id");
            Enumeration<Object> columnEnum = this.columnsHash.elements();
            while (columnEnum.hasMoreElements()) {
                Hashtable intern = (Hashtable)columnEnum.nextElement();
                Enumeration enumI = intern.keys();
                while (enumI.hasMoreElements()) {
                    String column = enumI.nextElement().toString();
                    String table = ((String)intern.get(column)).toString();
                    columns.append(",");
                    columns.append(this.getAlias(table));
                    columns.append(".");
                    columns.append(column);
                }
            }
        }
        return columns.toString();
    }

    private String setSortSpecification(SearchClassIntern sci) {
        String[] classname = sci.getSortClassnames();
        String[] attributeName = sci.getSortAttnames();
        int[] orders = sci.getSortOrders();
        int len = classname.length;
        StringBuffer sort = new StringBuffer();
        String trenn = "";
        for (int i = 0; i < len; ++i) {
            String cclass = classname[i] == null ? this.masterTable : classname[i];
            String column = attributeName[i] == null ? "ID" : attributeName[i];
            String lower = "";
            String lower_end = "";
            String order = "";
            if (orders[i] == 3 || orders[i] == 1) {
                DatabaseUtils du = new DatabaseUtils();
                try {
                    DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
                    String[] lowerArr = dbi.getLower(cclass, column);
                    lower = lowerArr[0];
                    lower_end = lowerArr[1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (orders[i]) {
                case 2: 
                case 3: {
                    order = " asc ";
                    break;
                }
                case 0: 
                case 1: {
                    order = " desc ";
                }
            }
            sort.append(trenn);
            sort.append(lower);
            sort.append(this.getAlias(cclass.toUpperCase()));
            sort.append(".");
            sort.append(column);
            sort.append(lower_end);
            sort.append(order);
            this.setColumn(cclass, column);
            trenn = ",";
        }
        return sort.toString();
    }

    private String setSortSpecificationByPosition(SearchClassIntern sci) {
        String[] attributeName = sci.getSortAttnames();
        int[] orders = sci.getSortOrders();
        StringBuffer sort = new StringBuffer();
        String trenn = "";
        int len = attributeName.length;
        for (int i = 0; i < len; ++i) {
            String column = attributeName[i];
            String lower = "";
            String lower_end = "";
            String order = "";
            if (orders[i] == 3 || orders[i] == 1) {
                DatabaseUtils du = new DatabaseUtils();
                try {
                    DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
                    String[] lowerArr = dbi.getLower(null, column);
                    lower = lowerArr[0];
                    lower_end = lowerArr[1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (orders[i]) {
                case 2: 
                case 3: {
                    order = " asc ";
                    break;
                }
                case 0: 
                case 1: {
                    order = " desc ";
                }
            }
            sort.append(trenn);
            sort.append(lower);
            sort.append(column);
            sort.append(lower_end);
            sort.append(order);
            trenn = ",";
        }
        return sort.toString();
    }

    private void setColumn(String classname, String column) {
        classname = classname.toUpperCase();
        column = column.toUpperCase();
        Hashtable intern = null;
        if (this.columnsHash.containsKey(classname)) {
            intern = (Hashtable)this.columnsHash.get(classname);
        } else {
            intern = new Hashtable();
            this.columnsHash.put(classname, intern);
        }
        if (!intern.containsKey(column)) {
            intern.put(column, classname);
        }
    }

    private void setSearchClause(SearchClassIntern sci) throws Exception {
        this.setSearchClause(sci, this.whereStack);
        this.setSearchClause(sci, this.whereStack2);
    }

    private void setSearchClause(SearchClassIntern sci, Vector<String> stack) throws Exception {
        int len = stack.size() - 1;
        if (len > 0) {
            String left = stack.elementAt(len).toString();
            stack.removeElementAt(len);
            String right = stack.elementAt(--len).toString();
            stack.removeElementAt(len);
            String clause = "";
            switch (sci.getSearchClause()) {
                case 1: {
                    clause = " AND ";
                    break;
                }
                case 2: {
                    clause = " OR ";
                    break;
                }
                case 0: {
                    clause = " NOT ";
                }
            }
            StringBuffer where = new StringBuffer();
            where.append("(");
            where.append(left);
            where.append(clause);
            where.append(right);
            where.append(")");
            stack.addElement(where.toString());
        }
    }

    private void setJoinQualification(SearchClassIntern sci) throws Exception {
        StringBuffer join = new StringBuffer();
        join.append(sci.getLeftAttributeClassname() == null ? this.getAlias(this.masterTable.toUpperCase()) : this.getAlias(sci.getLeftAttributeClassname().toUpperCase()));
        join.append(".");
        join.append(sci.getLeftAttributeName() == null ? "ID" : sci.getLeftAttributeName());
        join.append("=");
        join.append(sci.getRightAttributeClassname() == null ? this.getAlias(this.masterTable.toUpperCase()) : this.getAlias(sci.getRightAttributeClassname().toUpperCase()));
        join.append(".");
        join.append(sci.getRightAttributeName() == null ? "ID" : sci.getRightAttributeName());
        this.whereStack.addElement(join.toString());
        this.joinStack.addElement(join.toString());
    }

    private void setJoinQualificationPos(SearchClassIntern sci) throws Exception {
        StringBuffer join = new StringBuffer();
        join.append(ALIASE_NAME + (sci.getLeftAttClassnamePos() == null ? "0" : "" + sci.getLeftAttClassnamePos()));
        join.append(".");
        join.append(sci.getLeftAttributeName() == null ? "ID" : sci.getLeftAttributeName());
        join.append("=");
        join.append(ALIASE_NAME + (sci.getRightAttClassnamePos() == null ? "0" : "" + sci.getRightAttClassnamePos()));
        join.append(".");
        join.append(sci.getRightAttributeName() == null ? "ID" : sci.getRightAttributeName());
        this.whereStack.addElement(join.toString());
        this.joinStack.addElement(join.toString());
    }

    private void setAttributeQualification(SearchClassIntern sci) throws Exception {
        String table = sci.getAttributeClassname();
        if (table == null) {
            table = this.masterTable;
        }
        String alias = this.getAlias(table.toUpperCase());
        String startLower = "";
        String endLower = "";
        Object attrValue = sci.getAttributeValue();
        if (sci.getIgnoreCase() && attrValue instanceof String) {
            DatabaseUtils du = new DatabaseUtils();
            DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
            String[] lower = dbi.getLower(table, sci.getAttributeName());
            startLower = lower[0];
            endLower = lower[1];
        }
        String where = startLower + alias + "." + this.getAttributeAlias(sci.getAttributeName().toUpperCase()) + endLower;
        where = this.setAttributeQualificationOnly(sci, where);
        this.whereStack.addElement(where);
        this.whereStack2.addElement(where);
    }

    private void setAttributeQualificationPos(SearchClassIntern sci) throws Exception {
        String table = null;
        String alias = ALIASE_NAME + (sci.getLeftAttClassnamePos() == null ? "0" : "" + sci.getLeftAttClassnamePos());
        String startLower = "";
        String endLower = "";
        if (sci.getIgnoreCase()) {
            DatabaseUtils du = new DatabaseUtils();
            DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
            String[] lower = dbi.getLower(table, sci.getAttributeName());
            startLower = lower[0];
            endLower = lower[1];
        }
        String where = startLower + alias + "." + this.getAttributeAlias(sci.getAttributeName().toUpperCase()) + endLower;
        where = this.setAttributeQualificationOnly(sci, where);
        this.whereStack.addElement(where);
        this.whereStack2.addElement(where);
    }

    private String setAttributeQualificationOnly(SearchClassIntern sci, String where) throws Exception {
        Object attrValue = sci.getAttributeValue();
        int gaq = sci.getAttributeQualification();
        String className = sci.getAttributeClassname();
        String attrName = sci.getAttributeName();
        boolean isCI = this.isCIColumn(className, attrName);
        DatabaseUtils du = new DatabaseUtils();
        DatabaseInterface dbi = du.getDatabaseInterfaceImpl();
        if (isCI) {
            where = where + "CI";
        }
        if (gaq == 0) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(0, isCI);
            }
            if (attrValue instanceof String) {
                attrValue = dbi.escapeWildCards((String)attrValue, 0, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        } else if (gaq == 1) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(1, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        } else if (gaq == 2) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(2, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        }
        if (gaq == 3) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(3, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        } else if (gaq == 4) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(4, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        } else if (gaq == 5) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(5, isCI);
            }
            if (attrValue instanceof String) {
                attrValue = dbi.escapeWildCards((String)attrValue, 5, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        } else if (gaq == 6) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(6, isCI);
            }
        } else if (gaq == 7) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(7, isCI);
            }
        } else if (gaq == 8) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(8, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        } else if (gaq == 9) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(9, isCI);
            }
            this.bindAttributeValueFromSelect.add(0, attrValue);
        } else if (gaq == 10) {
            if (where != null) {
                where = where + dbi.getQualifierStatement(10, isCI, (String)attrValue);
            }
        } else if (gaq == 11 && where != null) {
            where = where + dbi.getQualifierStatement(11, isCI, (String)attrValue);
        }
        return where;
    }

    private boolean isCIColumn(String attClassname, String attName) {
        try {
            ClassObjectClientBean coAtt;
            Hashtable<String, Object> allAttr;
            AttributeObjectClientBean ao;
            boolean isCI = false;
            if (attClassname != null && attName != null && !attName.equalsIgnoreCase("id") && (ao = (AttributeObjectClientBean)(allAttr = this.sessionController.getAllAttributesFromClassId((coAtt = this.sessionController.getClassObject(attClassname)).getId())).get(attName)).getDataType().equals("CISTRING")) {
                isCI = true;
            }
            return isCI;
        }
        catch (Exception e) {
            System.err.println("Error in isCIColumn: " + attClassname + "." + attName);
            e.printStackTrace(System.err);
            return false;
        }
    }

    private String getAttributeAlias(String column) {
        return column;
    }

    public String getSQL() {
        return this.select.toString();
    }

    public void openSearch(String tableName) throws Exception {
        this.openSearch(tableName, null);
    }

    public void openSearch(String tableName, String searchName) throws Exception {
        try {
            this.setAgorumSearchObjectVector(tableName, searchName);
            SearchHome home = (SearchHome)EJBHomeHolder.getHome("ejb/Search");
            this.searchRemote = home.create();
            this.searchResultSet = this.searchRemote.openSearch(this.sessionController, tableName, this.countOnly, this.select.toString(), this.bindAttributeValue, this.withDeletor, this.isDistinct, this.distinctValues != null ? this.distinctValues.getDistinctClassnames() : null, this.distinctValues != null ? this.distinctValues.getDistinctAttnames() : null);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public ArrayList<List<AttributeValue>> specialSearch(String selectAttributeString, String fromTableString, String whereString, String sort, String[] selectAttributeDataTypes, Vector<Object> bindAttributes, boolean distinct) throws Exception {
        ArrayList<List<AttributeValue>> alRet = null;
        try {
            if (fromTableString.toUpperCase().indexOf(GlobalObjectClientBean.CLASS_NAME.toUpperCase()) >= 0) {
                this.className = new String[]{GlobalObjectClientBean.CLASS_NAME};
            }
            this.setWithDeletorAndSetAccessSettings(this.className);
            this.select = new StringBuffer();
            this.select.append("select ");
            this.select.append(selectAttributeString);
            this.select.append(" from ");
            this.select.append(fromTableString);
            this.whereStack = new Vector();
            this.whereStack.add(whereString);
            this.whereStack2.add(whereString);
            this.bindAttributeValueFromSelect = bindAttributes;
            this.setAccessToSelect(this.setAccessSettings, this.setAdminAccessSettings, this.withDeletor, this.countOnly, distinct, null);
            this.setBindVariables(this.setAccessSettings, this.setAdminAccessSettings, this.withDeletor);
            if (sort != null) {
                this.select.append(" " + sort);
            }
            SearchHome home = (SearchHome)EJBHomeHolder.getHome("ejb/Search");
            this.searchRemote = home.create();
            alRet = this.searchRemote.specialSearch(this.sessionController, this.select.toString(), selectAttributeDataTypes, this.bindAttributeValue, this.countOnly, this.withDeletor);
        }
        catch (Exception e) {
            try {
                String sqlStr = this.select.toString();
                System.err.println("Error-Select :\n" + sqlStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace(System.err);
            ExceptionUtils.handleException(e);
        }
        return alRet;
    }

    private void checkOpenSearch() throws Exception {
        if (this.searchRemote == null) {
            ExceptionUtils.handleException("Search has not been opened, use openSearch()", "agorum.roi.remote.exception.UseOpenSearch", 54);
        }
    }

    public boolean next() throws Exception {
        this.checkOpenSearch();
        return this.searchResultSet.next();
    }

    public int getSelectCounter() throws Exception {
        return this.searchResultSet.getSelectCounter();
    }

    public GlobalObjectClientBean getItem() throws Exception {
        this.checkOpenSearch();
        return this.searchResultSet.getItem();
    }

    public GlobalObjectClientBean[] getItems() throws Exception {
        this.checkOpenSearch();
        return this.searchResultSet.getItems();
    }

    public InternalObjectClientBean[] getItemsInternalObject() throws Exception {
        this.checkOpenSearch();
        return this.searchResultSet.getItemsInternalObject();
    }

    public DataBaseObjectClientBean[] getItemsDataBaseObject() throws Exception {
        this.checkOpenSearch();
        return this.searchResultSet.getItemsDataBaseObject();
    }

    public ArrayList<List<AttributeValue>> getDistinctList() throws Exception {
        this.checkOpenSearch();
        return this.searchResultSet.getDistinctList();
    }

    public void closeSearch() throws Exception {
        try {
            this.checkOpenSearch();
            this.searchRemote = null;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    private class SearchClassIntern {
        private Object attributeValue;
        private String attributeName;
        private String attributeClassname;
        private int attributeQualification = QUALIFICATION_NOQUALIFICATION;
        private int searchClause = SEARCHCLAUSE_NOCLAUSE;
        private int objectType = -1;
        private String[] className;
        private String[] aliasClassName;
        private boolean ignoreCase;
        private String leftAttName;
        private String leftAttClassname;
        private String rightAttName;
        private String rightAttClassname;
        private Integer leftAttClassnamePos;
        private Integer rightAttClassnamePos;
        private String[] sortClassnames;
        private String[] sortAttnames;
        private String[] distinctClassnames;
        private String[] distinctAttnames;
        private int[] sortOrders;
        private final int unionlevel;

        public SearchClassIntern(int unionlevel) {
            this.unionlevel = unionlevel;
        }

        public void setLeftAttributeName(String s) {
            this.leftAttName = s;
        }

        public void setLeftAttributeClassname(String s) {
            this.leftAttClassname = s;
        }

        public void setRightAttributeName(String s) {
            this.rightAttName = s;
        }

        public void setRightAttributeClassname(String s) {
            this.rightAttClassname = s;
        }

        public void setAttributeValue(Object o) {
            this.attributeValue = o;
        }

        public void setClassname(String[] s) {
            this.className = s;
        }

        public void setAliasClassname(String[] s) {
            this.aliasClassName = s;
        }

        public void setAttributeName(String s) {
            this.attributeName = s;
        }

        public void setAttributeQualification(int i) {
            this.attributeQualification = i;
        }

        public void setSearchClause(int i) {
            this.searchClause = i;
        }

        public void setObjectType(int i) {
            this.objectType = i;
        }

        public void setIgnoreCase(boolean b) {
            this.ignoreCase = b;
        }

        public void setAttributeClassname(String s) {
            this.attributeClassname = s;
        }

        public void setSortClassnames(String[] s) {
            this.sortClassnames = s;
        }

        public void setSortAttnames(String[] s) {
            this.sortAttnames = s;
        }

        public void setSortOrders(int[] b) {
            this.sortOrders = b;
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public int getAttributeQualification() {
            return this.attributeQualification;
        }

        public int getSearchClause() {
            return this.searchClause;
        }

        public int getObjectType() {
            return this.objectType;
        }

        public String[] getClassname() {
            return this.className;
        }

        public String[] getAliasClassname() {
            return this.aliasClassName;
        }

        public boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public String getLeftAttributeName() {
            return this.leftAttName;
        }

        public String getLeftAttributeClassname() {
            return this.leftAttClassname;
        }

        public String getRightAttributeName() {
            return this.rightAttName;
        }

        public String getRightAttributeClassname() {
            return this.rightAttClassname;
        }

        public String getAttributeClassname() {
            return this.attributeClassname;
        }

        public String[] getSortClassnames() {
            return this.sortClassnames;
        }

        public String[] getSortAttnames() {
            return this.sortAttnames;
        }

        public int[] getSortOrders() {
            return this.sortOrders;
        }

        public String[] getDistinctClassnames() {
            return this.distinctClassnames;
        }

        public void setDistinctClassnames(String[] distinctClassnames) {
            this.distinctClassnames = distinctClassnames;
        }

        public String[] getDistinctAttnames() {
            return this.distinctAttnames;
        }

        public void setDistinctAttnames(String[] distinctAttnames) {
            this.distinctAttnames = distinctAttnames;
        }

        public Integer getLeftAttClassnamePos() {
            return this.leftAttClassnamePos;
        }

        public void setLeftAttClassnamePos(Integer leftAttClassnamePos) {
            this.leftAttClassnamePos = leftAttClassnamePos;
        }

        public Integer getRightAttClassnamePos() {
            return this.rightAttClassnamePos;
        }

        public void setRightAttClassnamePos(Integer rightAttClassnamePos) {
            this.rightAttClassnamePos = rightAttClassnamePos;
        }

        public int getUnionlevel() {
            return this.unionlevel;
        }
    }
}

