/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.searchengine;

import agorum.roi.ejb.common.SessionController;
import agorum.roi.searchengine.AdvancedSearchResult;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.searchengine.SortInfo;
import agorum.roi.statistic.searchengine.DocumentServiceSearchEngineSearchSystemStatistic;
import java.util.Collection;
import java.util.Map;

public class AdvancedSearchQuery {
    private final SessionController sessionController;
    private final IndexHandlerInterface indexHandler;
    private final String query;
    private String[] filter;
    private SortInfo[] sort;
    private int start;
    private int rows = Integer.MAX_VALUE;
    private boolean withCursor;
    private String cursor;
    private boolean includeHidden;
    private boolean facet;
    private String[] facetFields;
    private int facetMinCount = 1;
    private int facetLimit = Integer.MAX_VALUE;
    private boolean facetMissing;
    private String facetSort;
    private Map<?, ?> facets;
    private Map<?, ?> highlights;
    private String[] properties;
    private static final DocumentServiceSearchEngineSearchSystemStatistic statisticHolder = new DocumentServiceSearchEngineSearchSystemStatistic();

    public AdvancedSearchQuery(SessionController sessionController) {
        this(sessionController, IndexHelper.getIndexHandler(statisticHolder), null);
    }

    public AdvancedSearchQuery(SessionController sessionController, IndexHandlerInterface indexHandler) {
        this(sessionController, indexHandler, null);
    }

    public AdvancedSearchQuery(SessionController sessionController, String query) {
        this(sessionController, IndexHelper.getIndexHandler(statisticHolder), query);
    }

    public AdvancedSearchQuery(SessionController sessionController, IndexHandlerInterface indexHandler, String query) {
        this.sessionController = sessionController;
        this.indexHandler = indexHandler;
        this.query = query;
    }

    public AdvancedSearchQuery filter(String ... filter) {
        this.filter = filter;
        return this;
    }

    public AdvancedSearchQuery sort(SortInfo ... sort) {
        this.sort = sort;
        return this;
    }

    public AdvancedSearchQuery start(int start) {
        this.start = start;
        return this;
    }

    public AdvancedSearchQuery rows(int rows) {
        this.rows = rows;
        return this;
    }

    public AdvancedSearchQuery cursor(boolean withCursor) {
        this.withCursor = withCursor;
        return this;
    }

    public AdvancedSearchQuery cursor(String cursor) {
        this.withCursor = true;
        this.cursor = cursor;
        return this;
    }

    public AdvancedSearchQuery includeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
        return this;
    }

    public AdvancedSearchQuery facetFields(String ... facetFields) {
        this.facet = true;
        this.facetFields = facetFields;
        return this;
    }

    public AdvancedSearchQuery facetMinCount(int facetMinCount) {
        this.facetMinCount = facetMinCount;
        return this;
    }

    public AdvancedSearchQuery facetLimit(int facetLimit) {
        this.facetLimit = facetLimit;
        return this;
    }

    public AdvancedSearchQuery facetMissing(boolean facetMissing) {
        this.facetMissing = facetMissing;
        return this;
    }

    public AdvancedSearchQuery facetSort(String facetSort) {
        this.facetSort = facetSort;
        return this;
    }

    public AdvancedSearchQuery facets(Map<?, ?> facets) {
        this.facets = facets;
        return this;
    }

    public AdvancedSearchQuery highlights(Map<?, ?> highlights) {
        this.highlights = highlights;
        return this;
    }

    public AdvancedSearchResult search(String ... properties) throws Exception {
        this.properties = properties;
        this.indexHandler.openForSearch();
        try {
            AdvancedSearchResult advancedSearchResult = this.indexHandler.advancedSearch(this);
            return advancedSearchResult;
        }
        finally {
            this.indexHandler.close();
        }
    }

    public AdvancedSearchResult search(Collection<String> properties) throws Exception {
        return this.search(properties.toArray(new String[properties.size()]));
    }

    public SessionController getSessionController() {
        return this.sessionController;
    }

    public String getQuery() {
        return this.query;
    }

    public String[] getFilter() {
        return this.filter;
    }

    public SortInfo[] getSort() {
        return this.sort;
    }

    public int getStart() {
        return this.start;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isWithCursor() {
        return this.withCursor;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public boolean isFacet() {
        return this.facet;
    }

    public String[] getFacetFields() {
        return this.facetFields;
    }

    public int getFacetMinCount() {
        return this.facetMinCount;
    }

    public int getFacetLimit() {
        return this.facetLimit;
    }

    public boolean isFacetMissing() {
        return this.facetMissing;
    }

    public String getFacetSort() {
        return this.facetSort;
    }

    public Map<?, ?> getFacets() {
        return this.facets;
    }

    public Map<?, ?> getHighlights() {
        return this.highlights;
    }
}

