/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.selector;

import agorum.roi.common.utils.Beans;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.BaseObject;
import agorum.roi.ejb.common.FolderObject;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.selector.Phrase;
import agorum.roi.selector.PhraseAttributeEqual;
import agorum.roi.selector.PhraseBoolean;
import agorum.roi.selector.PhraseDoubleSlash;
import agorum.roi.selector.PhraseGreater;
import agorum.roi.selector.PhraseID;
import agorum.roi.selector.PhraseLower;
import agorum.roi.selector.PhraseSlash;
import java.util.ArrayList;
import java.util.List;

public class Selector {
    private final List<Phrase> phrases;
    private final Priority priority;

    private Selector(List<Integer> priority, List<Phrase> phrases) {
        this.priority = new Priority(priority);
        this.phrases = phrases;
    }

    public static Selector compile(String str) {
        ArrayList<Phrase> phrases = new ArrayList<Phrase>();
        ArrayList<Integer> priority = new ArrayList<Integer>();
        if (str.isEmpty()) {
            return new Selector(priority, phrases);
        }
        Integer start = null;
        Integer stop = null;
        int regexBracks = 0;
        boolean isInBrackets = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '[') {
                if (start == null) {
                    start = i;
                    isInBrackets = true;
                } else {
                    ++regexBracks;
                }
            } else if (str.charAt(i) == ']') {
                if (regexBracks == 0) {
                    stop = i;
                    isInBrackets = false;
                }
                --regexBracks;
            } else if (str.charAt(i) == '/' && !isInBrackets) {
                if (i + 1 < str.length() && str.charAt(i + 1) == '/') {
                    phrases.add(new PhraseDoubleSlash());
                    ++i;
                } else {
                    phrases.add(new PhraseSlash());
                }
            }
            if (start == null || stop == null) continue;
            String sub = str.substring(start, stop + 1);
            if (sub.indexOf("=/") != -1) {
                phrases.add(Selector.createNewPhrase(sub, Phrase.TYPE.REGEX));
            } else {
                phrases.add(Selector.createNewPhrase(sub, Phrase.TYPE.STRING));
            }
            start = null;
            stop = null;
            regexBracks = 0;
        }
        int oldVal = 0;
        int index = 0;
        for (int j = phrases.size() - 1; j >= 0; --j) {
            Phrase p = (Phrase)phrases.get(j);
            while (priority.size() - 1 < index + 1) {
                priority.add(0);
            }
            if (p instanceof PhraseDoubleSlash) {
                index += 4;
                continue;
            }
            if (p instanceof PhraseSlash) {
                index += 2;
                continue;
            }
            if (p instanceof PhraseID) {
                if (index < priority.size()) {
                    oldVal = (Integer)priority.get(index);
                }
                priority.set(index, ++oldVal);
                continue;
            }
            if (index + 1 < priority.size()) {
                oldVal = (Integer)priority.get(index + 1);
            }
            priority.set(index + 1, ++oldVal);
        }
        return new Selector(priority, phrases);
    }

    Priority getPriority() {
        return this.priority;
    }

    List<Phrase> getPhrases() {
        return this.phrases;
    }

    public boolean selects(GlobalObjectClientBean object) {
        return this.selects(object.getSessionController(), object, this.phrases.size() - 1, false);
    }

    public boolean selects(SessionController sessionController, BaseObject object) {
        return this.selects(sessionController, object, this.phrases.size() - 1, false);
    }

    private boolean selects(SessionController sessionController, BaseObject object, int index, boolean ancestors) {
        if (index < 0) {
            return true;
        }
        Phrase phrase = this.phrases.get(index);
        try {
            if (phrase instanceof PhraseDoubleSlash) {
                for (FolderObject parent : object.parents()) {
                    if (!this.selects(sessionController, parent, index - 1, true)) continue;
                    return true;
                }
            } else if (phrase instanceof PhraseSlash) {
                for (FolderObject parent : object.parents()) {
                    if (!this.selects(sessionController, parent, index - 1, false)) continue;
                    return true;
                }
            } else {
                if (phrase.match(sessionController, object) && this.selects(sessionController, object, index - 1, false)) {
                    return true;
                }
                if (ancestors) {
                    for (FolderObject parent : object.parents()) {
                        if (!this.selects(sessionController, parent, index, ancestors)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            throw Beans.translate(e);
        }
        return false;
    }

    private static Phrase createNewPhrase(String phrase, Phrase.TYPE phraseType) {
        if (phrase.charAt(1) == '#') {
            return new PhraseID(phrase);
        }
        if (phrase.charAt(1) == '!') {
            return new PhraseBoolean(phrase);
        }
        if (phrase.contains("!=")) {
            return new PhraseAttributeEqual(phrase, phraseType);
        }
        if (phrase.contains(">=") || phrase.contains(">")) {
            return new PhraseGreater(phrase);
        }
        if (phrase.contains("<=") || phrase.contains("<")) {
            return new PhraseLower(phrase);
        }
        if (phrase.contains("=")) {
            return new PhraseAttributeEqual(phrase, phraseType);
        }
        return new PhraseBoolean(phrase);
    }

    public static class Priority
    implements Comparable<Priority> {
        private final List<Integer> priority;

        public Priority(List<Integer> priority) {
            this.priority = priority;
        }

        @Override
        public int compareTo(Priority o) {
            List<Integer> otherPrio = o.priority;
            List<Integer> thisPrio = this.priority;
            int count = thisPrio.size();
            if (thisPrio.size() > otherPrio.size()) {
                count = thisPrio.size();
                while (thisPrio.size() > otherPrio.size()) {
                    otherPrio.add(0);
                }
            }
            if (otherPrio.size() > thisPrio.size()) {
                count = otherPrio.size();
                while (otherPrio.size() > thisPrio.size()) {
                    thisPrio.add(0);
                }
            }
            for (int i = 0; i <= count - 1; ++i) {
                if (thisPrio.get(i) > otherPrio.get(i)) {
                    return 1;
                }
                if (thisPrio.get(i) >= otherPrio.get(i)) continue;
                return -1;
            }
            return 0;
        }
    }
}

