/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.beans;

import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.PermissionBundleObjectClientBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacade;

public class AccessControlListObjectSessionFacade
extends GlobalObjectSessionFacade {
    private Long granteeId = null;
    private DirectoryGroupObjectClientBean grantee = null;
    private String granteePermissionBundle = null;

    public AccessControlListObjectSessionFacade(SessionController sessionController) throws Exception {
        super(sessionController);
        this.setGlobalObjectClientBeanDefinition(new AccessControlListObjectClientBeanDefinition(sessionController));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean create() throws Exception {
        AccessControlListObjectClientBean poRet = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            poRet = (AccessControlListObjectClientBean)super.create();
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }

    public void addGranteeOrRevokee(Long newGranteeId, String newGranteePermissionBundle, boolean granted) throws Exception {
        this.addGranteeOrRevokee(this.getGranteeFromId(newGranteeId), newGranteePermissionBundle, granted);
    }

    public void addGranteeOrRevokee(DirectoryObjectClientBean grantee, String permissionBundle, boolean granted) throws Exception {
        try {
            AccessControlEntryObjectClientBeanDefinition aced = new AccessControlEntryObjectClientBeanDefinition(this.sessionController);
            aced.setGrantee(grantee);
            PermissionBundleObjectClientBean pb = this.sessionController.getPermissionBundleByName(permissionBundle);
            aced.addPermissionBundle(pb);
            aced.setGranted(granted);
            ((AccessControlListObjectClientBeanDefinition)this.getGlobalObjectClientBeanDefinition()).addGranteeOrRevokeeAceDefinition(aced);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    private DirectoryObjectClientBean getGranteeFromId(Long id) throws Exception {
        DirectoryObjectClientBean dObject = null;
        try {
            dObject = (DirectoryObjectClientBean)this.sessionController.getGlobalObjectById(id);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return dObject;
    }
}

