/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.beans;

import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.DirectoryObjectSessionFacade;

public class DirectoryGroupObjectSessionFacade
extends DirectoryObjectSessionFacade {
    private String destinationGroup = null;
    private boolean notCreateGroupAcl = false;
    private String directoryGroup = null;
    private String[] removeMembers = null;
    private String[] addMembers = null;

    public DirectoryGroupObjectSessionFacade(SessionController sessionController) throws Exception {
        super(sessionController);
        this.gosfc.setGlobalObjectClientBeanDefinition(new DirectoryGroupObjectClientBeanDefinition(sessionController));
    }

    public void setDestinationGroup(String destinationGroup) {
        this.destinationGroup = destinationGroup;
    }

    public void setDirectoryGroup(String directoryGroup) {
        this.directoryGroup = directoryGroup;
    }

    public void setRemoveMembers(String[] removeMembers) {
        this.removeMembers = removeMembers;
    }

    public void setAddMembers(String[] addMembers) {
        this.addMembers = addMembers;
    }

    public void check() throws Exception {
        String newName = null;
        try {
            newName = this.getGlobalObjectClientBeanDefinition().getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String checkName = null;
        String oldName = null;
        checkName = this.gosfc.getGlobalObject() != null ? (oldName = this.gosfc.getGlobalObject().getName()) : newName;
        FolderObjectClientBean destFolderObject = null;
        if (this.gosfc.getDestinationFolder() != null) {
            destFolderObject = this.gosfc.getDestinationFolder();
        } else if (this.gosfc.getGlobalObject() != null) {
            destFolderObject = this.gosfc.getGlobalObject().getParents()[0];
        }
        if (oldName == null && destFolderObject == null && newName != null) {
            ExceptionUtils.handleException("Destination folder does not exist.", "agorum.roi.remote.exception.DestinationFolderNotFound", 103);
        }
        if (newName != null && (oldName == null || !oldName.equalsIgnoreCase(newName)) && this.sessionController.isObjectExistant("DIRECTORYGROUPOBJECT", newName)) {
            ExceptionUtils.handleException("Group \"" + newName + "\" already exists.", "agorum.roi.remote.exception.GroupAlreadyExists", 300);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean create() throws Exception {
        this.check();
        DirectoryGroupObjectClientBean poRet = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            if (!this.notCreateGroupAcl) {
                this.setSystemOption("groupCreateGroupAcl", "");
            }
            this.addMembers();
            DirectoryGroupObjectClientBean dg = (DirectoryGroupObjectClientBean)super.create();
            this.setDestinationGroupIntern(dg);
            poRet = dg;
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }

    public void setDestinationGroupIntern(DirectoryGroupObjectClientBean dg) throws Exception {
        if (this.destinationGroup != null) {
            DirectoryGroupObjectClientBean dgDestination = (DirectoryGroupObjectClientBean)this.sessionController.getGlobalObjectById(new Long(this.destinationGroup));
            dgDestination.addMember(dg);
        }
    }

    private void addMembers() throws Exception {
        if (this.addMembers != null) {
            this.setSystemOption("groupAddMembers", this.getMembersFromStringArray(this.addMembers));
        }
    }

    private void removeMembers() throws Exception {
        if (this.removeMembers != null) {
            this.setSystemOption("groupRemoveMembers", this.getMembersFromStringArray(this.removeMembers));
        }
    }

    private DirectoryObjectClientBean[] getMembersFromStringArray(String[] sArr) throws Exception {
        DirectoryObjectClientBean[] doArr = null;
        int len = sArr.length;
        doArr = new DirectoryObjectClientBean[len];
        for (int i = 0; i < len; ++i) {
            doArr[i] = (DirectoryObjectClientBean)this.sessionController.getGlobalObjectById(new Long(sArr[i]));
        }
        return doArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean update() throws Exception {
        this.check();
        DirectoryGroupObjectClientBean poRet = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            this.addMembers();
            this.removeMembers();
            DirectoryGroupObjectClientBean dg = (DirectoryGroupObjectClientBean)super.update();
            this.setDestinationGroupIntern(dg);
            poRet = dg;
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }

    public void setNotCreateGroupAcl(boolean newNotCreateGroupAcl) {
        this.notCreateGroupAcl = newNotCreateGroupAcl;
    }
}

