/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.beans;

import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.common.SessionFacade;
import java.util.Enumeration;
import java.util.Hashtable;

public class RelationObjectSessionFacade
extends SessionFacade {
    private RelationObjectClientBeanDefinition relationDefinition = null;
    private String classname = null;
    private GlobalObjectClientBean globalObject = null;
    private Hashtable hSollRelationObjects = null;
    private Hashtable hActRelationObjects = null;
    private Hashtable hActRelations = null;
    public static final boolean RIGHTWARD_RELATIONSHIP = true;
    public static final boolean LEFTWARD_RELATIONSHIP = false;

    public RelationObjectSessionFacade(SessionController sessionController) throws Exception {
        super(sessionController);
    }

    public void setRelationObjectClientBeanDefinition(RelationObjectClientBeanDefinition relationDefinition) throws Exception {
        this.relationDefinition = relationDefinition;
        this.classname = this.sessionController.getClassObject(relationDefinition.getClassId()).getName();
    }

    public void setClassname(String classname) throws Exception {
        RelationObjectClientBeanDefinition rDef = new RelationObjectClientBeanDefinition(this.sessionController);
        rDef.setClassId(this.sessionController.getClassObject(classname).getId());
        this.relationDefinition = rDef;
        this.classname = classname;
    }

    public void setGlobalObject(Long globalObjectId) throws Exception {
        this.setGlobalObject(this.sessionController.getGlobalObjectById(globalObjectId));
    }

    public void setGlobalObject(GlobalObjectClientBean globalObject) {
        this.globalObject = globalObject;
    }

    public void setRelationObjectList(String[] relationObjectList) {
        this.hSollRelationObjects = this.getHashtableFromObjectList(relationObjectList);
    }

    public void create() throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            this.hActRelationObjects = new Hashtable();
            this.hActRelations = new Hashtable();
            this.fillActRelationsWithReadAccessFromGlobalObject(this.globalObject, this.classname, this.hActRelationObjects, this.hActRelations);
            this.getDiffSollAndIstObjects(this.hSollRelationObjects, this.hActRelationObjects, this.hActRelations);
            this.deleteRelationsFromGlobalObject(this.globalObject, this.hActRelations);
            this.addRelationship(this.globalObject, this.hSollRelationObjects, this.classname);
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
    }

    private void addRelationship(GlobalObjectClientBean gocb, Hashtable hSollRelationObjects, String relationClassname) throws Exception {
        if (gocb != null && hSollRelationObjects != null) {
            try {
                int len = hSollRelationObjects.size();
                if (len > 0) {
                    Enumeration objEnum = hSollRelationObjects.elements();
                    while (objEnum.hasMoreElements()) {
                        GlobalObjectClientBean gocbChild = null;
                        try {
                            gocbChild = (GlobalObjectClientBean)objEnum.nextElement();
                            if (this.isAlreadyRelated(gocb, gocbChild, relationClassname)) continue;
                            gocb.addRelationship(gocbChild, this.relationDefinition);
                        }
                        catch (Exception e) {
                            ExceptionUtils.handleException(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
        }
    }

    public void getDiffSollAndIstObjects(Hashtable hSollRelationObjects, Hashtable hActRelationObjects, Hashtable hActRelations) {
        Enumeration objEnum = hSollRelationObjects.keys();
        while (objEnum.hasMoreElements()) {
            String key = (String)objEnum.nextElement();
            if (!hActRelationObjects.containsKey(key)) continue;
            hActRelationObjects.remove(key);
            hActRelations.remove(key);
        }
    }

    public boolean isAlreadyRelated(GlobalObjectClientBean gocb, GlobalObjectClientBean gocbChild) throws Exception {
        return this.isAlreadyRelated(gocb, gocbChild, RelationObjectClientBean.CLASS_NAME);
    }

    public boolean isAlreadyRelated(GlobalObjectClientBean gocb, GlobalObjectClientBean gocbChild, String className) throws Exception {
        boolean anz = false;
        RelationObjectClientBean[] rArr = gocb.getRelations(className, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, gocbChild);
        return rArr != null;
    }

    public void update() throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            this.create();
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
    }
}

