/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.common;

import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import java.util.Enumeration;
import java.util.Hashtable;

public class SessionFacade {
    protected SessionController sessionController = null;
    protected boolean withTransaction = true;
    private Hashtable systemOptions = new Hashtable();
    public StringUtils su = new StringUtils();

    public SessionFacade(SessionController sessionController) throws Exception {
        this.sessionController = sessionController;
    }

    public RoiTransactionHandler getRoiTransactionHandler() {
        RoiTransactionHandler rth = null;
        if (this.getWithTransaction()) {
            rth = new RoiTransactionHandler();
            return rth;
        }
        return null;
    }

    public void setWithTransaction(boolean withTransaction) {
        this.withTransaction = withTransaction;
    }

    public boolean getWithTransaction() {
        return this.withTransaction;
    }

    public void beginTransaction(RoiTransactionHandler rth) throws Exception {
        if (rth != null) {
            rth.begin();
            this.setWithTransaction(false);
        }
    }

    public RoiTransactionHandler completeTransaction(RoiTransactionHandler rth) throws Exception {
        if (rth != null) {
            rth.end();
            rth = null;
        }
        return rth;
    }

    public RoiTransactionHandler abortTransaction(RoiTransactionHandler rth) throws Exception {
        if (rth != null) {
            rth.abort();
            rth = null;
        }
        return rth;
    }

    public Hashtable getHashtableFromObjectList(String[] objectList) {
        Hashtable<String, GlobalObjectClientBean> hRet = new Hashtable<String, GlobalObjectClientBean>();
        if (objectList != null) {
            for (String sId : objectList) {
                if (sId == null) continue;
                int pos = sId.indexOf("||");
                if (pos > 0) {
                    sId = sId.substring(0, pos);
                }
                try {
                    String key;
                    Long lId = new Long(sId);
                    GlobalObjectClientBean gocb = this.sessionController.getGlobalObjectById(lId);
                    if (gocb == null || hRet.containsKey(key = "" + gocb.getId())) continue;
                    hRet.put(key, gocb);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return hRet;
    }

    public void fillActRelationsWithReadAccessFromGlobalObject(GlobalObjectClientBean gocb, String relationClassname, Hashtable actRelationObjects, Hashtable actRelation) {
        if (gocb != null) {
            try {
                RelationObjectClientBean[] rs = gocb.getRightwardRelations(relationClassname);
                if (rs != null) {
                    for (int i = 0; i < rs.length; ++i) {
                        try {
                            GlobalObjectClientBean poR = rs[i].getRightObject();
                            String key = "" + poR.getId();
                            if (actRelationObjects.containsKey(key)) continue;
                            actRelationObjects.put(key, poR);
                            actRelation.put(key, rs[i]);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteRelationsFromGlobalObject(GlobalObjectClientBean globalObject, Hashtable hActRelations) {
        Enumeration relationEnum = hActRelations.elements();
        while (relationEnum.hasMoreElements()) {
            try {
                RelationObjectClientBean rs = (RelationObjectClientBean)relationEnum.nextElement();
                globalObject.removeRelationship(rs);
            }
            catch (Exception exception) {}
        }
    }

    public void setSystemOption(String optionName, Object value) {
        if (this.systemOptions.containsKey(optionName)) {
            this.systemOptions.remove(optionName);
        }
        if (value != null) {
            this.systemOptions.put(optionName, value);
        }
    }

    public Hashtable getAllSystemOption() {
        return this.systemOptions;
    }
}

