/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic;

import agorum.commons.cron.Trace;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.string.SerializableMap;
import agorum.roi.statistic.DashboardStatistic;
import java.util.ArrayList;
import java.util.Map;

public class AgorumProcessList
extends SystemStatistic {
    public static final AgorumProcessList instance = new AgorumProcessList((Statistic)DashboardStatistic.getInstance());

    public static AgorumProcessList getInstance() {
        return instance;
    }

    protected AgorumProcessList(Statistic parent) {
        super(parent);
        this.setServiceStatus(Statistic.ServiceStatus.NONE);
    }

    public String getPropertyType() {
        return "processes";
    }

    public String getDescription() {
        return "Shows currently running agorum processes";
    }

    public String getShortDescription() {
        return "agorum Processes";
    }

    public Map<String, Object> getPropertyMap(int rc, int depth) {
        Map result = super.getPropertyMap(rc, depth);
        ArrayList<Map> arr = new ArrayList<Map>();
        for (Trace.Group group : Trace.getThreadGroups()) {
            Map pmap = group.getPropertyMap(false);
            arr.add(pmap);
        }
        result.put("threadGroups", arr);
        result.put("traceEnabled", Trace.isEnabled());
        return result;
    }

    public SerializableMap serializeSettings() {
        SerializableMap data = super.serializeSettings();
        data.put((Object)"threadTraceEnabled", (Object)Trace.isEnabled());
        return data;
    }

    public void deserializeSettings(SerializableMap data) {
        super.deserializeSettings(data);
        Trace.setEnabled((boolean)data.getBoolean("threadTraceEnabled", Boolean.valueOf(false)));
    }

    public void reset() {
        super.reset();
        for (Trace.Group group : Trace.getThreadGroups()) {
            for (Trace.Info info : Trace.getThreadList((String)group.getName())) {
                info.clear();
            }
        }
    }
}

