/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.certificate;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.commons.string.StringConverterUtils;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.statistic.certificate.KeystoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Map;

public class KeystoreManagementAction
extends SystemAction {
    private static final KeystoreManagementAction instance = new KeystoreManagementAction(CoreStatistic.getInstance().getGroup("Actions"));

    protected KeystoreManagementAction(Statistic parent) {
        super(parent);
    }

    public static KeystoreManagementAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Import or export a keystore";
    }

    public String getShortDescription() {
        return "Keystore management";
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection();
        fields.attachment("keystore").title("Keystore").description("Keystore file to import").add();
        fields.passwordField("password").title("Keystore password").description("Enter the password of the keystore file to import.").add();
        fields.passwordField("newPassword").title("New password").description("Enter new password for 'Change keystore password', otherwise leave blank.").allowBlank(true).add();
        fields.button("import").description("Import keystore").add();
        fields.button("export").description("Export keystore").add();
        fields.button("change").description("Change keystore password").add();
        return fields.getCollection();
    }

    public boolean runActionSync(Map<String, Object> args) throws SystemTaskException {
        block9: {
            try {
                Map attachments = (Map)args.get("attachments");
                String button = (String)args.get("buttonId");
                String keystorePath = System.getProperty("javax.net.ssl.keyStore");
                File keystore = new File(keystorePath);
                String newKeystoreName = keystorePath.substring(0, keystorePath.lastIndexOf(".")) + "new.keystore";
                String keystorePass = (String)args.get("password");
                String newKeystorePass = (String)args.get("newPassword");
                Statistic.Attachment newKeystoreAttachment = (Statistic.Attachment)attachments.get("keystore");
                if ("import".equals(button)) {
                    if (newKeystoreAttachment.getFileName() == null || newKeystoreAttachment.getFileName().isEmpty()) {
                        this.error(null, "No attachment supplied", null);
                    } else {
                        InputStream is = newKeystoreAttachment.getStream();
                        File newKeystore = new File(newKeystoreName);
                        StringConverterUtils.pipe((InputStream)is, (OutputStream)new FileOutputStream(newKeystore));
                        KeystoreUtil unused = new KeystoreUtil(newKeystore, keystorePass.toCharArray());
                        if (keystore.exists() && !keystore.delete()) {
                            throw new Exception("Unable to replace old keystore file");
                        }
                        newKeystore.renameTo(new File(System.getProperty("javax.net.ssl.keyStore")));
                        this.setPromptAfterAction("Keystore imported successfully. The server must be restarted for the changes to take effect.");
                    }
                    break block9;
                }
                if ("export".equals(button)) {
                    keystore = new File(System.getProperty("javax.net.ssl.keyStore"));
                    this.setDownloadFile(keystore.getAbsolutePath());
                    break block9;
                }
                if (!"change".equals(button)) break block9;
                if (newKeystorePass.length() > 0) {
                    if (keystorePass.length() > 0) {
                        this.changePassword(keystore, keystorePass, newKeystorePass);
                        this.setPromptAfterAction("Password changed successfully. The server must be restarted for the changes to take effect.");
                        break block9;
                    }
                    throw new Exception("No old keystore password supplied");
                }
                throw new Exception("No new keystore password supplied");
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return false;
    }

    private void changePassword(File keystore, String oldPass, String newPass) throws Exception {
        KeyStore newStore = KeyStore.getInstance("JKS");
        newStore.load(new FileInputStream(keystore.getAbsoluteFile()), oldPass.toCharArray());
        newStore.store(new FileOutputStream(keystore), newPass.toCharArray());
        System.setProperty("javax.net.ssl.keyStorePassword", newPass);
        MetaDbAccessor mdba = new MetaDbAccessor(this.getName());
        try (MetaDbUtil mdbu = mdba.getWriteUtil("MAIN_MODULE_MANAGEMENT/roi/control/keystore");){
            mdbu.setString("KeystorePassword", newPass);
            mdbu.commit();
        }
        try {
            KeystoreUtil.prepareServerXML(newPass);
        }
        catch (Exception e) {
            String startupUpdatePath = System.getProperty("jboss.server.home.dir") + "/../../../startup_updates/jboss/server/default/deploy/jbossweb-tomcat50.sar/server.xml";
            File xml = new File(startupUpdatePath);
            xml.delete();
            throw new Exception("Unable to set the new password in file: '" + System.getProperty("jboss.server.home.dir") + "/deploy/jbossweb-tomcat50.sar/server.xml'. Please replace the password in this file with your changed password, to avoid serious problems with your keystore", e);
        }
        KeystoreUtil.removeAutoSelfSignedGeneration();
    }
}

