/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemTaskAbortedException;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class AgorumCoreBenchCheck
extends SystemCheck {
    private static final AgorumCoreBenchCheck instance = new AgorumCoreBenchCheck(CoreStatistic.getInstance().getGroup("Checks"));
    private static final String BASE_PATH = "/agorum/roi/performancetest";

    protected AgorumCoreBenchCheck(Statistic parent) {
        super(parent);
    }

    public static AgorumCoreBenchCheck getInstance() {
        return instance;
    }

    private StatisticDetail test1(SessionController sessionController, FolderObjectClientBean testFolder) throws Exception {
        this.info().detail((Object)"creating many folders").send("Running test 1");
        StatisticDetail detail = new StatisticDetail();
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        long time = System.currentTimeMillis();
        try (Transaction t = new Transaction();){
            for (long i = 0L; i < 1000L; ++i) {
                if (this.abortRequired()) {
                    throw new SystemTaskAbortedException();
                }
                rfs.createFullpath("test_" + i, testFolder, testFolder.getAcl());
            }
            t.commit();
        }
        time = System.currentTimeMillis() - time;
        long referenceValueGood = 15000L;
        long referenceValueMid = 28000L;
        detail.title = "Test 1";
        detail.unit = "ms";
        detail.detail = "creating many folders";
        detail.referenceValue = new Double(referenceValueGood);
        detail.actualValue = new Double(time);
        detail.performanceStatus = time < referenceValueGood ? Statistic.PerformanceStatus.OK : (time < referenceValueMid ? Statistic.PerformanceStatus.WARN : Statistic.PerformanceStatus.CRITICAL);
        return detail;
    }

    private StatisticDetail test2(SessionController sessionController, FolderObjectClientBean testFolder) throws Exception {
        this.info().detail((Object)"getting items from folder").send("Running test 2");
        StatisticDetail detail = new StatisticDetail();
        long time = System.currentTimeMillis();
        try (Transaction t = new Transaction();){
            for (long i = 0L; i < 100L; ++i) {
                if (this.abortRequired()) {
                    throw new SystemTaskAbortedException();
                }
                testFolder.getItems();
            }
            t.commit();
        }
        time = System.currentTimeMillis() - time;
        long referenceValueGood = 1500L;
        long referenceValueMid = 3500L;
        detail.title = "Test 2";
        detail.unit = "ms";
        detail.detail = "getting items from folder";
        detail.referenceValue = new Double(referenceValueGood);
        detail.actualValue = new Double(time);
        detail.performanceStatus = time < referenceValueGood ? Statistic.PerformanceStatus.OK : (time < referenceValueMid ? Statistic.PerformanceStatus.WARN : Statistic.PerformanceStatus.CRITICAL);
        return detail;
    }

    private StatisticDetail test3(SessionController sessionController, FolderObjectClientBean testFolder) throws Exception {
        this.info().detail((Object)"deleting items").send("Running test 3");
        StatisticDetail detail = new StatisticDetail();
        long time = System.currentTimeMillis();
        try (Transaction t = new Transaction();){
            GlobalObjectClientBean[] items;
            for (GlobalObjectClientBean item : items = testFolder.getItems()) {
                if (this.abortRequired()) {
                    throw new SystemTaskAbortedException();
                }
                item.delete();
            }
            t.commit();
        }
        time = System.currentTimeMillis() - time;
        long referenceValueGood = 10000L;
        long referenceValueMid = 16000L;
        detail.title = "Test 3";
        detail.unit = "ms";
        detail.detail = "deleting items from folder";
        detail.referenceValue = new Double(referenceValueGood);
        detail.actualValue = new Double(time);
        detail.performanceStatus = time < referenceValueGood ? Statistic.PerformanceStatus.OK : (time < referenceValueMid ? Statistic.PerformanceStatus.WARN : Statistic.PerformanceStatus.CRITICAL);
        return detail;
    }

    private StatisticDetail test4(SessionController sessionController, FolderObjectClientBean testFolder) throws Exception {
        this.info().detail((Object)"creating small files").send("Running test 4");
        StatisticDetail detail = new StatisticDetail();
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        long time = System.currentTimeMillis();
        try (Transaction t = new Transaction();){
            byte[] buffer = new byte[100];
            for (long i = 0L; i < 300L; ++i) {
                if (this.abortRequired()) {
                    throw new SystemTaskAbortedException();
                }
                ByteArrayInputStream content = new ByteArrayInputStream(buffer);
                rfs.putDocument("testfile_" + i, content, testFolder.getAnyFolderPath(), testFolder.getAcl(), false);
                content = null;
            }
            t.commit();
        }
        time = System.currentTimeMillis() - time;
        long referenceValueGood = 8000L;
        long referenceValueMid = 14000L;
        detail.title = "Test 4";
        detail.unit = "ms";
        detail.detail = "creating small files";
        detail.referenceValue = new Double(referenceValueGood);
        detail.actualValue = new Double(time);
        detail.performanceStatus = time < referenceValueGood ? Statistic.PerformanceStatus.OK : (time < referenceValueMid ? Statistic.PerformanceStatus.WARN : Statistic.PerformanceStatus.CRITICAL);
        return detail;
    }

    private StatisticDetail test5(SessionController sessionController, FolderObjectClientBean testFolder) throws Exception {
        this.info().detail((Object)"creating large files").send("Running test 5");
        StatisticDetail detail = new StatisticDetail();
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        long time = System.currentTimeMillis();
        try (Transaction t = new Transaction();){
            byte[] buffer = new byte[0xA00000];
            for (long i = 0L; i < 30L; ++i) {
                if (this.abortRequired()) {
                    throw new SystemTaskAbortedException();
                }
                ByteArrayInputStream content = new ByteArrayInputStream(buffer);
                rfs.putDocument("testfilebig_" + i, content, testFolder.getAnyFolderPath(), testFolder.getAcl(), false);
                content = null;
            }
            t.commit();
        }
        time = System.currentTimeMillis() - time;
        long referenceValueGood = 7000L;
        long referenceValueMid = 12000L;
        detail.title = "Test 5";
        detail.unit = "ms";
        detail.detail = "creating large files";
        detail.referenceValue = new Double(referenceValueGood);
        detail.actualValue = new Double(time);
        detail.performanceStatus = time < referenceValueGood ? Statistic.PerformanceStatus.OK : (time < referenceValueMid ? Statistic.PerformanceStatus.WARN : Statistic.PerformanceStatus.CRITICAL);
        return detail;
    }

    private StatisticDetail test6(SessionController sessionController, FolderObjectClientBean testFolder) throws Exception {
        this.info().detail((Object)"deleting files").send("Running test 6");
        StatisticDetail detail = new StatisticDetail();
        long time = System.currentTimeMillis();
        try (Transaction t = new Transaction();){
            GlobalObjectClientBean[] items;
            for (GlobalObjectClientBean item : items = testFolder.getItems()) {
                if (this.abortRequired()) {
                    throw new SystemTaskAbortedException();
                }
                item.delete();
            }
            t.commit();
        }
        time = System.currentTimeMillis() - time;
        long referenceValueGood = 3500L;
        long referenceValueMid = 7000L;
        detail.title = "Test 6";
        detail.unit = "ms";
        detail.detail = "deleting files";
        detail.referenceValue = new Double(referenceValueGood);
        detail.actualValue = new Double(time);
        detail.performanceStatus = time < referenceValueGood ? Statistic.PerformanceStatus.OK : (time < referenceValueMid ? Statistic.PerformanceStatus.WARN : Statistic.PerformanceStatus.CRITICAL);
        return detail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin("SystemStatistic");
        try {
            Object object;
            RoiFileSystem rfs = new RoiFileSystem(sessionController);
            FolderObjectClientBean testFolder = rfs.createFullpath("/agorum/roi/performancetest/test_" + System.currentTimeMillis());
            try {
                StatisticDetail detail = this.test1(sessionController, testFolder);
                this.details.add(detail);
                detail = this.test2(sessionController, testFolder);
                this.details.add(detail);
                detail = this.test3(sessionController, testFolder);
                this.details.add(detail);
                detail = this.test4(sessionController, testFolder);
                this.details.add(detail);
                detail = this.test5(sessionController, testFolder);
                this.details.add(detail);
                detail = this.test6(sessionController, testFolder);
                this.details.add(detail);
                this.performanceStatus = Statistic.PerformanceStatus.OK;
                object = this.details.iterator();
                while (object.hasNext()) {
                    StatisticDetail d = (StatisticDetail)object.next();
                    this.performanceStatus = AgorumCoreBenchCheck.setLowerState((Statistic.PerformanceStatus)d.performanceStatus, (Statistic.PerformanceStatus)this.performanceStatus);
                }
                return;
            }
            finally {
                Transaction t = new Transaction();
                object = null;
                try {
                    this.info().detail((Object)"cleaning up test folder").send("Clean up");
                    testFolder.delete();
                    t.commit();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (t != null) {
                        if (object != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
        }
        catch (SystemTaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemTaskException("Error performing agorum core performance benchmark", (Throwable)e);
        }
    }

    public String getDescription() {
        return "agorum core benchmark";
    }

    public String getShortDescription() {
        return "agorum core benchmark";
    }
}

