/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemTaskAbortedException;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.statistic.RoiStatistics;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class CPUBenchCheck
extends SystemCheck {
    private static final CPUBenchCheck instance = new CPUBenchCheck(CoreStatistic.getInstance().getGroup("Checks"));
    private static final double SCORE_MID = 7.0;
    private static final double SCORE_GOOD = 10.0;

    protected CPUBenchCheck(Statistic parent) {
        super(parent);
    }

    public static CPUBenchCheck getInstance() {
        return instance;
    }

    private void test1(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        int i = 0;
        while ((long)i < rounds) {
            String s = "";
            for (int j = 0; j < 100; ++j) {
                s = s + "" + j;
            }
            ++i;
        }
    }

    private void test4(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        byte[] buffer = new byte[0xA00000];
        Random rand = new Random(System.currentTimeMillis());
        int i = 0;
        while ((long)i < rounds) {
            rand.nextBytes(buffer);
            ++i;
        }
    }

    private void test5(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        Random rand = new Random(System.currentTimeMillis());
        int i = 0;
        while ((long)i < rounds) {
            byte[] buffer = new byte[0xA00000];
            rand.nextBytes(buffer);
            ++i;
        }
    }

    private void test6(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        int i = 0;
        while ((long)i < rounds) {
            final class TestClass {
                TestClass() {
                }

                void recurseTest(int count, String s) {
                    if (count < 100) {
                        s = s + "-";
                        this.recurseTest(++count, s);
                    }
                }
            }
            TestClass tc = new TestClass();
            tc.recurseTest(0, "");
            ++i;
        }
    }

    private void test7(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        Random rand = new Random(System.currentTimeMillis());
        byte[] buffer = new byte[0xA00000];
        byte[] buffer2 = new byte[0xA00000];
        rand.nextBytes(buffer);
        int i = 0;
        while ((long)i < rounds) {
            System.arraycopy(buffer, 0, buffer2, 0, buffer.length);
            ++i;
        }
    }

    private void test9(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        double d = 2.38942398473298E14;
        int i = 0;
        while ((long)i < rounds) {
            double d1 = d / (double)(i + 1);
            if (d1 == 0.0) {
                d1 *= 2.0;
            }
            ++i;
        }
    }

    private void test10(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        double d = 9.47593487539487E14;
        int i = 0;
        while ((long)i < rounds) {
            double d1 = d * (double)(i + 1);
            if (d1 == 0.0) {
                d1 *= 2.0;
            }
            ++i;
        }
    }

    private void test8(long rounds) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        int i = 0;
        while ((long)i < rounds) {
            this.test1(1L);
            this.test4(1L);
            this.test5(1L);
            this.test6(1L);
            this.test7(1L);
            this.test9(1L);
            this.test10(1L);
            ++i;
        }
    }

    private void test11(long rounds, int threads) throws SystemTaskException {
        if (this.abortRequired()) {
            throw new SystemTaskAbortedException();
        }
        final class TestCpuThread
        extends Thread {
            long rounds;

            TestCpuThread(long rounds) {
                this.rounds = rounds;
            }

            @Override
            public void run() {
                try {
                    CPUBenchCheck.this.test8(this.rounds);
                }
                catch (SystemTaskException systemTaskException) {
                    // empty catch block
                }
            }
        }
        ArrayList<TestCpuThread> tL = new ArrayList<TestCpuThread>();
        for (int t = 0; t < threads; ++t) {
            TestCpuThread testCpuThread = new TestCpuThread(rounds);
            testCpuThread.start();
            tL.add(testCpuThread);
        }
        for (Thread thread : tL) {
            try {
                thread.join();
            }
            catch (Exception exception) {}
        }
    }

    private void printPerformance(String msg, long time, Map<String, Long> times) {
        long duration = System.currentTimeMillis() - time;
        this.info().detail((Object)("Duration: " + duration + " ms")).send(msg);
        Long td = times.get(msg);
        if (td == null) {
            td = 0L;
        }
        td = td + duration;
        times.put(msg, td);
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        try {
            LinkedHashMap<String, Long> times = new LinkedHashMap<String, Long>();
            this.info().detail((Object)"Doing some operations, please standby...").send("Starting benchmark");
            long passes = 0L;
            for (int pass = 0; pass < 3; ++pass) {
                this.info().detail((Object)"Perform operations 3 times").send("Loop " + ++passes + "/3");
                long time = System.currentTimeMillis();
                this.test1(600000L);
                this.printPerformance("Test 1 (strings)", time, times);
                time = System.currentTimeMillis();
                this.test4(100L);
                this.printPerformance("Test 2 (random buffers)", time, times);
                time = System.currentTimeMillis();
                this.test5(100L);
                this.printPerformance("Test 3 (random buffers 2)", time, times);
                time = System.currentTimeMillis();
                this.test6(200000L);
                this.printPerformance("Test 4 (recursion)", time, times);
                time = System.currentTimeMillis();
                this.test7(2500L);
                this.printPerformance("Test 5 (buffer copy)", time, times);
                time = System.currentTimeMillis();
                this.test8(50L);
                this.printPerformance("Test 6 (combined tests)", time, times);
                time = System.currentTimeMillis();
                this.test9(200000000L);
                this.printPerformance("Test 7 (math 2)", time, times);
                time = System.currentTimeMillis();
                this.test10(200000000L);
                this.printPerformance("Test 8 (math 3)", time, times);
                time = System.currentTimeMillis();
                this.test11(50L, 2);
                this.printPerformance("Test 9 (multithreading)", time, times);
            }
            long sum = 0L;
            for (Map.Entry timesEntry : times.entrySet()) {
                sum += (Long)timesEntry.getValue() / passes;
            }
            DecimalFormat df = new DecimalFormat("0.00");
            double score = 320000.0 / (double)sum;
            double percentScore = RoiStatistics.percent(score, 10.0);
            StatisticDetail detail = new StatisticDetail();
            detail.title = "Result";
            if (score < 7.0) {
                this.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
                this.info().detail((Object)("The benchmark did not achieve a good score " + df.format(score) + " (" + percentScore + "%), status: " + this.performanceStatus)).send("JVM is too slow");
                detail.detail = "JVM is too slow, please use CPU cores with more GHz";
            } else if (score < 10.0) {
                this.performanceStatus = Statistic.PerformanceStatus.WARN;
                this.info().detail((Object)("The benchmark did not achieve a perferct score " + df.format(score) + "  (" + percentScore + "%), status: " + this.performanceStatus)).send("JVM is a bit too slow");
                detail.detail = "JVM is a bit too slow, please use CPU cores with more GHz";
            } else {
                this.performanceStatus = Statistic.PerformanceStatus.OK;
                this.info().detail((Object)("The bench did fairly well, score  " + df.format(score) + " (" + percentScore + "%), status: " + this.performanceStatus)).send("JVM cpu is fast enough");
                detail.detail = "JVM is fast enough";
            }
            detail.unit = "score";
            detail.performanceStatus = this.performanceStatus;
            detail.actualValue = score;
            detail.referenceValue = 10.0;
            this.details.add(detail);
            this.info().detail((Object)("Benchmark finished, time: " + df.format(score) + " / " + 10.0 + " (" + percentScore + "%)")).send("Finished benchmark");
        }
        catch (SystemTaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemTaskException("Error performing benchmark", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Checking CPU performance of the agorum core server";
    }

    public String getShortDescription() {
        return "CPU benchmark";
    }
}

