/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.statistic.RoiCheckSuite;
import java.util.Map;

public class DBSpaceCheck
extends RoiCheckSuite {
    private static final DBSpaceCheck instance = new DBSpaceCheck(CoreStatistic.getInstance().getGroup("Checks"));
    private SessionController sessionController;
    private static final int WARNING_VALUE = 80;
    private static final int ERROR_VALUE = 95;

    protected DBSpaceCheck(Statistic parent) {
        super(parent);
    }

    public static DBSpaceCheck getInstance() {
        return instance;
    }

    protected void initialize(Map<String, Object> args) throws SystemTaskException {
        this.sessionController = SessionControllerAdmin.getSessionControllerAdmin(DBSpaceCheck.class.getName());
        this.addCheck("Calculating used database space", () -> {
            try {
                float percentage = (float)((double)this.sessionController.getDBSize() * 100.0 / (double)this.sessionController.getTotalDbSize() + 0.5);
                String formatted = String.format("%.02f", Float.valueOf(percentage));
                if (percentage < 80.0f) {
                    this.ok(formatted + "% of your DB space is used");
                } else if (percentage >= 80.0f && percentage < 95.0f) {
                    this.warn(formatted + "% of your DB space is used");
                } else if (percentage >= 95.0f) {
                    this.fail(formatted + "% of your DB space is used");
                }
            }
            catch (Exception e) {
                this.fail("Unable to check DB space", e);
            }
        });
    }

    public String getDescription() {
        return "Checking the total and used database space";
    }

    public String getShortDescription() {
        return "DB space";
    }
}

