/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.config;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.util.MetaDbUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ActiveServicesConfig
extends SystemConfig {
    private static final String NAME_EA = "eventAssistance";
    private static final String PATH_EA = "MAIN_MODULE_MANAGEMENT/roi/control/eventassistance/";
    private static final String NAME_PD = "pathDate";
    private static final String PATH_PD = "MAIN_MODULE_MANAGEMENT/roi/control/pathdate/";
    private static final String ACTIVE = "Active";
    private static final SystemStatistic stat = CoreStatistic.getInstance();
    private static final ActiveServicesConfig instance = new ActiveServicesConfig(stat.getGroup("Configurations"));

    public static ActiveServicesConfig getInstance() {
        return instance;
    }

    protected ActiveServicesConfig(Statistic parent) {
        super(parent);
    }

    private SessionController getSc() {
        return SessionControllerAdmin.getService(ActiveServicesConfig.class);
    }

    public String getDescription() {
        return "Manage active services";
    }

    public String getShortDescription() {
        return "Active services";
    }

    public Map<String, Object> formLoad() {
        SessionController sc = this.getSc();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put(NAME_EA, MetaDbSuperCache.isTrue(sc, "MAIN_MODULE_MANAGEMENT/roi/control/eventassistance/Active"));
        formData.put(NAME_PD, MetaDbSuperCache.isTrue(sc, "MAIN_MODULE_MANAGEMENT/roi/control/pathdate/Active"));
        return formData;
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection(formData);
        fields.boolField(NAME_EA).title("Event Assistance").description("The Event Assistance service is used by desk4web to notify users about new or updated objects that concern them, either because they subscribed to a parent folder's updates or because the object is directed at them like a note or workflow activity.").add();
        fields.boolField(NAME_PD).title("Path Date").description("The Path Date service propagates changes to a folder's contents upwards. The results are used by the WebDAV server, the ContentChange service and specialized Time-Phased Actions.").add();
        return fields.getCollection();
    }

    public void formButton(Map<String, Object> args) {
        block26: {
            try {
                if (!ActiveServicesConfig.isButton((String)"save", args)) break block26;
                SessionController sc = this.getSc();
                try (MetaDbUtil mdu = new MetaDbUtil(sc, PATH_EA);){
                    mdu.setBoolean(ACTIVE, (Boolean)args.get(NAME_EA));
                    mdu.commit();
                }
                mdu = new MetaDbUtil(sc, PATH_PD);
                var4_5 = null;
                try {
                    mdu.setBoolean(ACTIVE, (Boolean)args.get(NAME_PD));
                    mdu.commit();
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (mdu != null) {
                        if (var4_5 != null) {
                            try {
                                mdu.close();
                            }
                            catch (Throwable throwable) {
                                var4_5.addSuppressed(throwable);
                            }
                        } else {
                            mdu.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.error(e);
            }
        }
    }
}

