/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.measurement;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.measurement.Histogram;
import agorum.commons.statistic.measurement.WatchableMeasurement;

public class JvmMemoryLoad
extends Histogram {
    private static final long MEGABYTE = 0x100000L;
    private static final long FREE_MEMORY_CRITICAL = 256L;

    public JvmMemoryLoad() {
        super(false, "JVM Free Memory", "MB");
    }

    public long getValue() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public long getMaximum() {
        return Runtime.getRuntime().maxMemory() / 0x100000L;
    }

    public void onTick(Statistic parent) {
        super.onTick(parent);
        this.set(this.getValue());
    }

    public void loadDefaults() {
        this.addCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.LESS, 256L));
    }
}

