/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.measurement;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.measurement.Histogram;
import agorum.commons.statistic.measurement.WatchableMeasurement;
import java.io.File;

public class ServerDiskSpaceSolr
extends Histogram {
    private static final long MEGABYTE = 0x100000L;
    private static final long FREE_MEMORY_CRITICAL = 1024L;
    private String dir = null;

    public ServerDiskSpaceSolr(String dir, String name) {
        super(false, "Solr Free Disk Space (" + name + ")", "MB");
        this.dir = dir;
    }

    public long getValue() {
        return new File(this.dir).getUsableSpace() / 0x100000L;
    }

    public long getMaximum() {
        return new File(this.dir).getTotalSpace() / 0x100000L;
    }

    public void onTick(Statistic parent) {
        super.onTick(parent);
        this.set(this.getValue());
    }

    public void loadDefaults() {
        this.addCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.LESS, 1024L));
    }
}

