/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.searchengine;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.statistic.measurement.Histogram;
import agorum.commons.statistic.measurement.Measurement;
import agorum.commons.statistic.measurement.WatchableMeasurement;
import agorum.roi.statistic.searchengine.SearchEngineStatistic;

public class ContentIndexStatistic
extends SystemStatistic {
    public static final String MEASUREMENT_QUEUE_SIZE_CREATES = "Content queue size: Creates (number of new objects in index)";
    public static final String MEASUREMENT_QUEUE_SIZE_UPDATES = "Content queue size: Updates (number of updated objects in index)";
    public static final String MEASUREMENT_QUEUE_SIZE_PATH_UPDATES = "Content queue size: Path Updates (number of reindexed or moved objects in index)";
    private static final long MAX_CREATES = 1000L;
    private static final long MAX_UPDATES = 1000L;
    private static final long MAX_PATH_UPDATES = 1000L;
    private static final ContentIndexStatistic instance = new ContentIndexStatistic(SearchEngineStatistic.getInstance().getGroup("Sub Statistics"));

    private ContentIndexStatistic(Statistic parent) {
        super(parent);
    }

    public static ContentIndexStatistic getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Content extraction statistics";
    }

    public String getShortDescription() {
        return "Content extraction";
    }

    static {
        instance.addMeasurement((Measurement)new Histogram(false, MEASUREMENT_QUEUE_SIZE_CREATES).setDefaultCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.GREATER, 1000L)));
        instance.addMeasurement((Measurement)new Histogram(false, MEASUREMENT_QUEUE_SIZE_UPDATES).setDefaultCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.GREATER, 1000L)));
        instance.addMeasurement((Measurement)new Histogram(false, MEASUREMENT_QUEUE_SIZE_PATH_UPDATES).setDefaultCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.GREATER, 1000L)));
    }
}

