/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.searchengine;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemLink;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.statistic.searchengine.SearchEngineStatistic;
import agorum.roi.statistic.searchengine.SearchEngineSystemConfig;
import java.util.Map;

public class IndexExportedCheck
extends SystemCheck {
    private static final IndexExportedCheck instance = new IndexExportedCheck(SearchEngineStatistic.getInstance().getGroup("Checks"));
    private static final String BASE_KEY_SEARCH = "MAIN_MODULE_MANAGEMENT/textindexservice/control";
    private static final String BASE_KEY_INDEX = "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer";

    protected IndexExportedCheck(Statistic parent) {
        super(parent);
    }

    public static IndexExportedCheck getInstance() {
        return instance;
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        MetaDbAccessor mdba = new MetaDbAccessor(this.getName());
        try (MetaDbUtil mdbIndex = mdba.getReadUtil(BASE_KEY_INDEX);
             MetaDbUtil mdbSearch = mdba.getReadUtil(BASE_KEY_SEARCH);){
            StatisticDetail detail = new StatisticDetail();
            this.details.add(detail);
            String searchEngine = mdbSearch.getString("SearchEngine", "lucene_1_9");
            if (searchEngine.toLowerCase().startsWith("lucene_")) {
                boolean isExported = mdbIndex.getBoolean("DoExportIndexToFS", false);
                detail.title = "Exported index";
                if (isExported) {
                    String path = mdbIndex.getString("ExportIndexDirectory", "/opt/agorum/index/exported_index");
                    detail.detail = "The index is exported to " + path;
                    detail.performanceStatus = Statistic.PerformanceStatus.OK;
                } else {
                    detail.detail = "The index is not exported. Please export it, to increase the search and index performance";
                    detail.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
                    detail.link = new SystemLink();
                    detail.link.setDescription("Open index settings");
                    detail.link.setLink(SearchEngineSystemConfig.getInstance().getLink());
                }
                StatisticDetail detailRT = new StatisticDetail();
                detailRT.title = "Realtime index";
                boolean rtIndex = mdbSearch.getBoolean("realtimeindexenabled", false);
                if (rtIndex) {
                    detailRT.detail = "Realtime index is enabled";
                    detailRT.performanceStatus = Statistic.PerformanceStatus.OK;
                } else {
                    detailRT.detail = "Realtime index is not enabled, it is recommended to enable it.";
                    detailRT.performanceStatus = Statistic.PerformanceStatus.WARN;
                    detailRT.link = new SystemLink();
                    detailRT.link.setDescription("Open index settings");
                    detailRT.link.setLink(SearchEngineSystemConfig.getInstance().getLink());
                }
                this.details.add(detailRT);
                this.performanceStatus = IndexExportedCheck.setLowerState((Statistic.PerformanceStatus)detail.performanceStatus, (Statistic.PerformanceStatus)detailRT.performanceStatus);
            } else {
                detail.title = "Info";
                detail.detail = "You are running solr, so no index exporting is necessary";
                this.performanceStatus = detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            }
        }
        catch (Exception e) {
            throw new SystemTaskException("Error getting index queue info", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Index exported check";
    }

    public String getShortDescription() {
        return "Index exported check";
    }
}

