/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.searchengine;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.mbeans.ToTextIndexInfo;
import agorum.roi.statistic.searchengine.SearchEngineStatistic;
import java.util.Map;

public class IndexQueueCheck
extends SystemCheck {
    private static final IndexQueueCheck instance = new IndexQueueCheck(SearchEngineStatistic.getInstance().getGroup("Checks"));

    protected IndexQueueCheck(Statistic parent) {
        super(parent);
    }

    public static IndexQueueCheck getInstance() {
        return instance;
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        this.performanceStatus = Statistic.PerformanceStatus.OK;
        try {
            ToTextIndexInfo ttii = ToTextIndexInfo.getInstance();
            StatisticDetail detail = new StatisticDetail();
            this.details.add(detail);
            detail.actualValue = (double)ttii.getTextIndexQueue() + (double)ttii.getTextIndexQueue1() + (double)ttii.getTextIndexQueue2();
            detail.title = "Queue";
            detail.detail = "Total amount of index queue entries";
            detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            detail.referenceValue = 0.0;
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.actualValue = ttii.getActIndexQueue();
            detail.title = "Current loop";
            detail.detail = "Amount of current index loop";
            detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            detail.referenceValue = 0.0;
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.actualValue = ttii.getTextIndexQueue();
            detail.title = "Queue 1";
            detail.detail = "Index queue for creates";
            detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            detail.referenceValue = 0.0;
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.actualValue = ttii.getTextIndexQueue1();
            detail.title = "Queue 2";
            detail.detail = "Index queue for updates";
            detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            detail.referenceValue = 0.0;
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.actualValue = ttii.getTextIndexQueue2();
            detail.title = "Queue 3";
            detail.detail = "Index queue for path updates";
            detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            detail.referenceValue = 0.0;
        }
        catch (Exception e) {
            throw new SystemTaskException("Error getting index queue info", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Index queue info";
    }

    public String getShortDescription() {
        return "Index queue info";
    }
}

