/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.workers;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.statistic.workers.WorkersStatistic;
import agorum.roi.workers.QueryScript;
import java.util.Collection;
import java.util.Map;

public class QueryScriptAction
extends SystemAction {
    private static final QueryScriptAction instance = new QueryScriptAction(WorkersStatistic.getInstance().getGroup("Actions"), null, null);
    private final String name;
    private final QueryScript worker;

    protected QueryScriptAction(Statistic parent, String name, QueryScript worker) {
        super(name, parent);
        this.name = name;
        this.worker = worker;
    }

    public static QueryScriptAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Query Script Worker" + (this.name == null ? "" : ": " + this.name);
    }

    public String getShortDescription() {
        return "QueryScript " + (this.name == null ? "" : ": " + this.name);
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        int initialConcurrency = 4;
        boolean initialIncludeHidden = false;
        String initialQuery = "";
        String[] initialProperties = new String[]{"uuid"};
        String initialScript = "/* global sc, data */\n\nlet objects = require('common/objects');\n\n";
        if (this.worker != null) {
            initialConcurrency = this.worker.getConcurrency();
            initialIncludeHidden = this.worker.includeHidden();
            initialQuery = this.worker.getQuery();
            initialProperties = this.worker.getProperties();
            initialScript = this.worker.getScript();
        }
        FormItem.Collection fields = new FormItem.Collection();
        if (this.name == null) {
            fields.stringField("name").title("Name").description("Worker Name").allowBlank(false).add();
        }
        fields.intField("concurrency").title("Concurrency").description("Worker concurrency level").allowBlank(false).value((Object)initialConcurrency).add();
        fields.boolField("includeHidden").title("Hidden objects").description("Include hidden objects (history objects, sub-objects) in the working set").allowBlank(false).value((Object)initialIncludeHidden).add();
        fields.stringField("query").title("Query").description("Query").allowBlank(false).value((Object)initialQuery).add();
        fields.stringArrayField("properties").title("Properties").description("Properties").value((Object)initialProperties).add();
        fields.scriptField("script").title("JavaScript").description("JavaScript code").allowBlank(false).value((Object)initialScript).add();
        if (this.name == null) {
            fields.button("save").description("Save as new worker").add();
        } else {
            fields.button("save").description("Update worker script").add();
            fields.button("reset").description("Reset worker").add();
            fields.button("remove").description("Stop and remove worker").add();
        }
        return fields.getCollection();
    }

    /*
     * Unable to fully structure code
     */
    public boolean runActionSync(Map<String, Object> config) throws SystemTaskException {
        try {
            var2_2 = (String)config.get("buttonId");
            var3_4 = -1;
            switch (var2_2.hashCode()) {
                case 3522941: {
                    if (!var2_2.equals("save")) break;
                    var3_4 = 0;
                    break;
                }
                case 108404047: {
                    if (!var2_2.equals("reset")) break;
                    var3_4 = 1;
                    break;
                }
                case -934610812: {
                    if (!var2_2.equals("remove")) break;
                    var3_4 = 2;
                }
            }
            switch (var3_4) {
                case 0: {
                    concurrency = ((Number)config.get("concurrency")).intValue();
                    includeHidden = (Boolean)config.get("includeHidden");
                    query = (String)config.get("query");
                    properties = (String[])config.get("properties");
                    script = (String)config.get("script");
                    if (this.name != null) ** GOTO lbl28
                    name = (String)config.get("name");
                    node = QueryScriptAction.create(name, concurrency, script, includeHidden, query, properties);
                    this.setStatisticRedirectionName(node);
                    ** GOTO lbl52
lbl28:
                    // 1 sources

                    t = new Transaction();
                    var10_13 = null;
                    try {
                        this.worker.setConcurrency(concurrency);
                        this.worker.includeHidden(includeHidden);
                        this.worker.setQuery(query);
                        this.worker.setProperties(properties);
                        this.worker.setScript(script);
                        t.commit();
                    }
                    catch (Throwable var11_15) {
                        var10_13 = var11_15;
                        throw var11_15;
                    }
                    finally {
                        if (t != null) {
                            if (var10_13 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable var11_14) {
                                    var10_13.addSuppressed(var11_14);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
lbl52:
                    // 2 sources

                    this.info("Configuration saved");
                    break;
                }
                case 1: {
                    this.worker.reset();
                    this.info("Worker reset successfully");
                    break;
                }
                case 2: {
                    this.worker.remove();
                    this.removeFromParent();
                    this.setStatisticRedirectionName(QueryScriptAction.instance.getName());
                }
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        return false;
    }

    public static String create(String name, int concurrency, String script, boolean includeHidden, String query, String ... properties) {
        QueryScript worker = new QueryScript(name, concurrency, script, includeHidden, query, properties);
        worker.start();
        return new QueryScriptAction(WorkersStatistic.getInstance().getGroup("Actions"), name, worker).getName();
    }
}

