/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.test;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.parser.common.CreateRoiObjectsFromParseObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLParser;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TestLowLevel {
    public SessionController sessionController = null;

    public TestLowLevel(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public String mapPathToOS(String path) {
        return path.replace('/', File.separatorChar);
    }

    public Hashtable getCounterDiff(Hashtable start, Hashtable end, String ok, String err) throws Exception {
        Hashtable<String, Long> hRet = new Hashtable<String, Long>();
        Hashtable s = start;
        Hashtable e = end;
        Enumeration startEnum = s.keys();
        while (startEnum.hasMoreElements()) {
            String key = startEnum.nextElement().toString();
            Long lE = (Long)e.get(key);
            Long lS = (Long)s.get(key);
            if (e.containsKey(key)) {
                e.remove(key);
            }
            if (s.containsKey(key)) {
                s.remove(key);
            }
            try {
                long diff;
                if (lE == null && lS != null) {
                    hRet.put(key, lS);
                }
                if (lE != null && lS == null) {
                    hRet.put(key, lE);
                }
                if (lE == null || lS == null || (diff = lE - lS) == 0L) continue;
                hRet.put(key, new Long(diff));
            }
            catch (Exception exception) {}
        }
        if (hRet.size() == 0) {
            System.err.println(ok);
        } else if (err.length() > 0) {
            System.err.println(err + " ----------------> ERROR");
            this.printCounterDiff(hRet);
        }
        return hRet;
    }

    public void printCounterDiff(Hashtable diffHash) throws Exception {
        System.err.println("----------- Start Differenz ------------------------");
        Enumeration diffEnum = diffHash.keys();
        while (diffEnum.hasMoreElements()) {
            String key = diffEnum.nextElement().toString();
            long diff = (Long)diffHash.get(key);
            System.err.println("Diff " + key + " = " + diff);
        }
        System.err.println("----------- End Differenz ------------------------");
    }

    public boolean checkMainObject(Object fromObject, String relationName) throws Exception {
        GlobalObjectClientBean gocb = this.getGlobalObject(fromObject);
        this.existGlobalObject(gocb);
        boolean error = true;
        if (gocb != null) {
            GlobalObjectClientBean[] goArr = gocb.getRightwardRelationObjects(relationName);
            if (goArr != null) {
                int len = goArr.length;
                for (int i = 0; i < len; ++i) {
                    if (goArr[i].getMainObject().getId().longValue() != gocb.getMainObject().getId().longValue()) {
                        System.err.println("MainObject from " + goArr[i].getName() + " = " + goArr[i].getMainObject().getName() + ", expected : " + gocb.getName());
                        error = true;
                        break;
                    }
                    System.err.println("MainObject from " + goArr[i].getName() + " O.K.");
                    error = false;
                }
            } else {
                System.err.println("Has no Relation : " + relationName);
            }
        }
        return error;
    }

    public boolean checkCountAttachment(Object fromObject, int expectedAttachments) throws Exception {
        GlobalObjectClientBean gocb = this.getGlobalObject(fromObject);
        this.existGlobalObject(gocb);
        boolean error = true;
        if (gocb != null) {
            GlobalObjectClientBean[] goArr = gocb.getAllAttachments();
            int len = 0;
            if (goArr != null) {
                len = goArr.length;
            }
            if (len == expectedAttachments) {
                System.err.println("Attachments O.K.");
                error = false;
            } else {
                System.err.println("Attachments count " + len + " (expected: " + expectedAttachments + ")");
            }
        }
        return error;
    }

    public boolean existAcl(Object o) throws Exception {
        AccessControlListObjectClientBean acl = this.getAcl(o);
        boolean error = true;
        if (acl != null) {
            error = false;
        }
        if (!error) {
            System.err.println("exist Acl : " + acl.getName() + " O.K.");
        } else {
            System.err.println("Acl :  not exist ------> ERROR");
        }
        return error;
    }

    public boolean existGlobalObject(Object fromObject) throws Exception {
        return this.existGlobalObject(fromObject, "O.K.", "ERROR");
    }

    public boolean existGlobalObject(Object fromObject, String txtExist, String txtNotExist) throws Exception {
        Vector v = new Vector();
        GlobalObjectClientBean gocb = this.getGlobalObject(fromObject, v);
        boolean error = true;
        if (gocb != null) {
            error = false;
        }
        if (!error) {
            System.err.println("exist Object : " + v.elementAt(0).toString() + " " + txtExist);
        } else {
            System.err.println("Object " + v.elementAt(0).toString() + " not exist ------> " + txtNotExist);
        }
        return error;
    }

    public boolean checkAcl(Object fromObject, Object expectedAcl) throws Exception {
        GlobalObjectClientBean gocb = this.getGlobalObject(fromObject);
        AccessControlListObjectClientBean acl = this.getAcl(expectedAcl);
        this.existGlobalObject(gocb);
        this.existAcl(acl);
        boolean error = true;
        if (gocb != null && acl != null) {
            if (gocb.getAcl().getId().longValue() == acl.getId().longValue()) {
                System.err.println("ACL from " + gocb.getName() + " O.K.");
                error = false;
            }
            if (error) {
                System.err.println("Object : " + gocb.getName() + " has wrong ACL : " + gocb.getAcl().getName() + " ( Expected : " + acl.getName() + ")  -------------> ERROR");
            }
        }
        return error;
    }

    public boolean checkOwner(GlobalObjectClientBean gocb, DirectoryUserObjectClientBean expectedOwner) throws Exception {
        boolean error = true;
        if (gocb.getOwner().getId().longValue() == expectedOwner.getId().longValue()) {
            System.err.println("OWNER from " + gocb.getName() + " O.K.");
            error = false;
        }
        if (error) {
            System.err.println("Object : " + gocb.getName() + " has wrong OWNER : " + gocb.getOwner().getName() + " ( Expected : " + expectedOwner.getName() + ")  -------------> ERROR");
        }
        return error;
    }

    public boolean checkLastModifirer(GlobalObjectClientBean gocb, DirectoryUserObjectClientBean expectedOwner) throws Exception {
        boolean error = true;
        if (gocb.getLastModifier().getId().longValue() == expectedOwner.getId().longValue()) {
            System.err.println("LastModifirer from " + gocb.getName() + " O.K.");
            error = false;
        }
        if (error) {
            System.err.println("Object : " + gocb.getName() + " has wrong LASTMODIFIRER : " + gocb.getLastModifier().getName() + " ( Expected : " + expectedOwner.getName() + ")  -------------> ERROR");
        }
        return error;
    }

    public boolean checkCreator(GlobalObjectClientBean gocb, DirectoryUserObjectClientBean expectedOwner) throws Exception {
        boolean error = true;
        if (gocb.getCreator().getId().longValue() == expectedOwner.getId().longValue()) {
            System.err.println("Creator from " + gocb.getName() + " O.K.");
            error = false;
        }
        if (error) {
            System.err.println("Object : " + gocb.getName() + " has wrong LASTMODIFIRER : " + gocb.getCreator().getName() + " ( Expected : " + expectedOwner.getName() + ")  -------------> ERROR");
        }
        return error;
    }

    public AccessControlListObjectClientBean getAcl(Object o) throws Exception {
        AccessControlListObjectClientBean acl = null;
        if (o != null) {
            if (o instanceof AccessControlListObjectClientBean) {
                acl = (AccessControlListObjectClientBean)o;
            } else if (o instanceof String) {
                acl = this.sessionController.getAclByName((String)o);
            } else if (o instanceof Long) {
                acl = (AccessControlListObjectClientBean)this.sessionController.getGlobalObjectById((Long)o);
            }
        }
        return acl;
    }

    public GlobalObjectClientBean getGlobalObject(Object o) throws Exception {
        return this.getGlobalObject(o, new Vector());
    }

    public GlobalObjectClientBean getGlobalObject(Object o, Vector v) throws Exception {
        GlobalObjectClientBean gocb = null;
        String name = null;
        if (o != null) {
            if (o instanceof GlobalObjectClientBean) {
                gocb = (GlobalObjectClientBean)o;
                name = gocb.getName();
            } else if (o instanceof Long) {
                gocb = this.sessionController.getGlobalObjectById((Long)o);
                name = "" + (Long)o;
            } else if (o instanceof String) {
                gocb = this.sessionController.findGlobalObjectByPathOrId((String)o);
                name = (String)o;
            }
        }
        if (gocb != null) {
            name = gocb.getName();
        }
        v.addElement(name);
        return gocb;
    }

    public void importXMLToRoi(String path) throws Exception {
        System.err.println("ImportFromXML : " + path);
        long time1 = new Date().getTime();
        RoiXMLParser roiXMLParser = new RoiXMLParser(this.sessionController);
        roiXMLParser.setDocument(path);
        ParserObject po = roiXMLParser.parse();
        CreateRoiObjectsFromParseObject createRoiObjectsFromParseObject = new CreateRoiObjectsFromParseObject(this.sessionController);
        createRoiObjectsFromParseObject.create(po);
        System.err.println("Zeit: " + (new Date().getTime() - time1));
    }

    public static SessionController login(String userName, String password) throws Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        credential.setPassWord(password);
        credential.setModulInfo("TestLowLevel");
        SessionController sessionController = SessionController.connect(credential);
        return sessionController;
    }
}

