/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.timephasedaction.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.OpenFileHelper;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.interfaces.timephasedaction.TimePhasedActionInterface;
import agorum.roi.search.SearchClass;
import agorum.roi.statistic.timephasedactions.TimePhasedActionStatistic;
import agorum.roi.statistic.timephasedactions.TimePhasedActionSubStatistic;
import agorum.roi.timephasedaction.common.TimePhasedActionBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TimePhasedActionUtils {
    public static final String TIMEBASEDACTION_METADB = "MAIN_MODULE_MANAGEMENT/timephasedaction/control";
    private static final Date PERIODIC_DATE = new Date(15768000000L);
    private static final Date RESET_THRESHOLD = new Date(31536000000L);
    private static final String STICKY_ID_TIMEPHASEDACTION = "STICKY_ID_TIMEPHASEDACTION_";
    static Set<Long> lockSet = new HashSet<Long>();
    static Object lock = new Object();

    public boolean hasAccess(SessionController sessionController, GlobalObjectClientBean globalObject, String action) throws Exception {
        TimePhasedActionSubStatistic stat = TimePhasedActionSubStatistic.getInstance(action);
        TimePhasedActionInterface interf = this.loadInterface(sessionController, action);
        if (interf != null && interf.hasAccess((SystemStatistic)stat, sessionController, globalObject, action)) {
            return true;
        }
        return interf == null;
    }

    public boolean hasAccess(SessionController sessionController, String className, String action) throws Exception {
        TimePhasedActionSubStatistic stat = TimePhasedActionSubStatistic.getInstance(action);
        TimePhasedActionInterface interf = this.loadInterface(sessionController, action);
        return interf != null && interf.hasAccess((SystemStatistic)stat, sessionController, className, action);
    }

    public TimePhasedActionInterface loadInterface(SessionController sessionController, String action) throws Exception {
        TimePhasedActionInterface interf = null;
        TimePhasedActionSubStatistic stat = TimePhasedActionSubStatistic.getInstance(action);
        try {
            String classname = null;
            try {
                MetaDb mdb = sessionController.getMetaDbInstance();
                classname = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/timephasedaction/control/" + action + "/Class")[0];
            }
            catch (Throwable mdb) {
                // empty catch block
            }
            if (classname != null) {
                try {
                    Class<?> c = Class.forName(classname);
                    interf = (TimePhasedActionInterface)c.newInstance();
                }
                catch (Throwable e) {
                    stat.error(e, "Action not Found: " + action + ", class: " + classname);
                }
            }
        }
        catch (Throwable e) {
            stat.error(e, "Error loading interface");
        }
        return interf;
    }

    public TimePhasedActionBean[] getActions(SessionController sessionController, GlobalObjectClientBean clientBean) throws Exception {
        ArrayList<TimePhasedActionBean> v;
        TimePhasedActionBean[] timePhasedActionBean;
        block6: {
            TimePhasedActionStatistic stat = TimePhasedActionStatistic.getInstance();
            timePhasedActionBean = null;
            v = new ArrayList<TimePhasedActionBean>();
            try {
                MetaDb mdb = sessionController.getMetaDbInstance();
                String[] allActions = mdb.listSimplePropertyBundle(TIMEBASEDACTION_METADB);
                if (allActions == null) break block6;
                int len = allActions.length;
                for (int i = 0; i < len; ++i) {
                    if (!this.hasAccess(sessionController, clientBean, allActions[i])) continue;
                    TimePhasedActionBean tpab = new TimePhasedActionBean();
                    String textkey = null;
                    try {
                        textkey = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/timephasedaction/control/" + allActions[i] + "/TextKey")[0];
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    tpab.setAction(allActions[i]);
                    tpab.setTextkey(textkey);
                    v.add(tpab);
                }
            }
            catch (Throwable e) {
                stat.error(e, "Error loading actions");
            }
        }
        int len = v.size();
        if (len > 0) {
            timePhasedActionBean = v.toArray(new TimePhasedActionBean[0]);
        }
        return timePhasedActionBean;
    }

    public void findAndRunAction(SessionController sessionController, String timePhaseActionName) throws Exception {
        TimePhasedActionSubStatistic stat = TimePhasedActionSubStatistic.getInstance(timePhaseActionName);
        if (stat.logDebug()) {
            stat.debug("Looking for active actions");
        }
        GlobalObjectClientBean[] soArr = null;
        SearchClass sc = new SearchClass(sessionController);
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME});
        sc.setAttributeNOT_EQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.TIMEPHASEDACTIONDATE_ATTRIBUTE, (Object)new Date(0L), false);
        sc.setAttributeLESS_THAN(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.TIMEPHASEDACTIONDATE_ATTRIBUTE, (Object)new Date(), false);
        sc.setSearchClauseAND();
        if (timePhaseActionName != null) {
            sc.setAttributeEQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.TIMEPHASEDACTION_ATTRIBUTE, (Object)timePhaseActionName, false);
            sc.setSearchClauseAND();
        }
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME, "TimePhasedActionTimerTask.run");
        soArr = sc.getItems();
        if (soArr != null) {
            if (stat.logDebug()) {
                stat.debug("found " + soArr.length + " actions");
            }
            ArrayList<String> failedTpas = new ArrayList<String>();
            for (GlobalObjectClientBean globalObject : soArr) {
                if (stat.logDebug()) {
                    stat.debug().object((SystemObjectReference)globalObject).send("found action for object " + globalObject.getName());
                }
                if (globalObject.getParents() != null) {
                    if (!(globalObject.isLocked() || globalObject.isLockedForSession() || OpenFileHelper.randomFileHash.containsKey("" + globalObject.getId()))) {
                        if (System.currentTimeMillis() - globalObject.getUpdateDate().getTime() > 10000L && !this.runAction(stat, sessionController, globalObject)) {
                            failedTpas.add(globalObject.getID() + ":" + globalObject.getName());
                        }
                    } else if (stat.logDebug()) {
                        stat.debug().object((SystemObjectReference)globalObject).send("Don't run action yet, cause file is still locked");
                    }
                }
                String stickyId = STICKY_ID_TIMEPHASEDACTION + timePhaseActionName;
                stat.clearStickyLogEntry(stickyId);
                if (failedTpas.size() <= 0) continue;
                stat.error().sticky(stickyId).detail((Object)"The following action objects failed:").detail((Object)String.join((CharSequence)"\n", failedTpas)).detail((Object)"Check the log for detailed error information").send("Errors while executing timephased action '" + timePhaseActionName + "'");
            }
        } else if (stat.logDebug()) {
            stat.debug("found no actions");
        }
    }

    public boolean runAction(SessionController sessionController, GlobalObjectClientBean globalObject) {
        return this.runAction(TimePhasedActionStatistic.getInstance(), sessionController, globalObject);
    }

    public static void setPeriodic(GlobalObjectClientBean object, String timePhasedAction) throws Exception {
        Date tpaDate = object.getTimePhasedActionDate();
        if (timePhasedAction != null && !timePhasedAction.equals(object.getTimePhasedAction()) || tpaDate.after(RESET_THRESHOLD) || tpaDate.getTime() == 0L) {
            try (Transaction t = new Transaction();){
                SessionController sc = TimePhasedActionUtils.getSessionController();
                object = sc.getGlobalObjectById(object.getId());
                SuperObjectClientBeanDefinition def = object.getNewDefinition(sc);
                def.setSystemOption("doNotEA", "true");
                def.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, AttributeValue.newAttributeValueObject(object.getLastModifier()));
                if (timePhasedAction != null) {
                    def.setAttribute(GlobalObjectClientBean.TIMEPHASEDACTION_ATTRIBUTE, AttributeValue.newAttributeValueObject(timePhasedAction));
                }
                def.setAttribute(GlobalObjectClientBean.TIMEPHASEDACTIONDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(PERIODIC_DATE));
                object.update(def);
                t.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean runAction(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean globalObject) {
        boolean success = true;
        String action = "";
        try (Transaction trans = new Transaction();){
            TimePhasedActionInterface interf;
            block30: {
                block31: {
                    stat.count("TimePhasedAction Runs", 1L);
                    action = globalObject.getTimePhasedAction();
                    if (stat.logInfo()) {
                        stat.info().object((SystemObjectReference)globalObject).send("running action");
                    }
                    if ((interf = this.loadInterface(sessionController, action)) == null) break block30;
                    boolean locked = false;
                    Object object = lock;
                    // MONITORENTER : object
                    if (lockSet.contains(globalObject.getId())) {
                        locked = true;
                    } else {
                        lockSet.add(globalObject.getId());
                    }
                    // MONITOREXIT : object
                    if (locked) break block31;
                    try {
                        globalObject = sessionController.getGlobalObjectById(globalObject.getId());
                        Date tpaDate = globalObject.getTimePhasedActionDate();
                        if (tpaDate.getTime() == 0L) {
                            if (stat.logDebug()) {
                                stat.debug().object((SystemObjectReference)globalObject).send("action had just finished, won't restart");
                            }
                        } else {
                            if (tpaDate.after(RESET_THRESHOLD)) {
                                SessionController sessionController2 = TimePhasedActionUtils.getSessionController();
                                GlobalObjectClientBean clientBean2 = sessionController2.getGlobalObjectById(globalObject.getId());
                                SuperObjectClientBeanDefinition def = globalObject.getNewDefinition(sessionController2);
                                def.setSystemOption("doNotEA", "true");
                                def.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, AttributeValue.newAttributeValueObject(clientBean2.getLastModifier()));
                                def.setAttribute(GlobalObjectClientBean.TIMEPHASEDACTIONDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Date(0L)));
                                clientBean2.update(def);
                            }
                            interf.invokeFast(stat, sessionController, globalObject, action);
                            trans.restart();
                            interf.invoke(stat, sessionController, globalObject, action);
                        }
                        object = lock;
                    }
                    catch (Throwable throwable) {
                        Object object2 = lock;
                        // MONITORENTER : object2
                        lockSet.remove(globalObject.getId());
                        // MONITOREXIT : object2
                        throw throwable;
                    }
                    lockSet.remove(globalObject.getId());
                    // MONITOREXIT : object
                    break block30;
                }
                if (stat.logWarn()) {
                    stat.warning().object((SystemObjectReference)globalObject).send("action is already running");
                }
            }
            trans.commit();
            if (interf == null) return success;
            interf.invokePost(stat, sessionController, globalObject, action);
            return success;
        }
        catch (Exception e) {
            stat.error().object((SystemObjectReference)globalObject).exception((Throwable)e).send("Error running action '" + action + "': " + e.getLocalizedMessage());
            return false;
        }
    }

    private static SessionController getSessionController() {
        SessionController sc = SessionControllerAdmin.getSessionControllerAdmin("TimePhasedAction_AuditStatus");
        sc.setAuditState(AuditUtil.ACTION_EXT_NOT_ENTRY);
        return sc;
    }
}

