/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.util;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.common.utils.TemplateUtil;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.SessionController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;

public class JdbcConnectionFactory {
    private static String fill(String value, Map<String, Object> parameters) throws Exception {
        if (parameters == null) {
            return value;
        }
        return TemplateUtil.fillTemplate(parameters, value, false);
    }

    public static Connection getConnection(SessionController sessionController, String metaDbKey, Map<String, Object> parameters) throws Exception {
        MetaDb metaDb = sessionController.getMetaDbInstance();
        try {
            String driver = JdbcConnectionFactory.fill(metaDb.getSimplePropertyValue(metaDbKey + "/Driver")[0], parameters);
            Class.forName(driver).newInstance();
        }
        catch (Exception driver) {
            // empty catch block
        }
        String url = JdbcConnectionFactory.fill(metaDb.getSimplePropertyValue(metaDbKey + "/URL")[0], parameters);
        String username = JdbcConnectionFactory.fill(metaDb.getSimplePropertyValue(metaDbKey + "/Username")[0], parameters);
        String password = metaDb.getSimplePropertyValue(metaDbKey + "/Password")[0];
        CryptKeyController cryptKeyController = new CryptKeyController();
        password = JdbcConnectionFactory.fill(cryptKeyController.tryDecrypt(password, "metadb", sessionController), parameters);
        return DriverManager.getConnection(url, username, password);
    }
}

