/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.util;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.MetaDbSearchClassFilterBean;
import java.util.ArrayList;

public class MetaDbSearchClassFilterUtility {
    private MetaDb metaDb = null;
    private SessionController sessionController = null;

    public MetaDbSearchClassFilterUtility(SessionController sessionController) {
        this.sessionController = sessionController;
        try {
            this.metaDb = sessionController.getMetaDbInstance();
        }
        catch (MetaDbException e) {
            e.printStackTrace();
        }
    }

    public ArrayList getMetaDbSearchClassFilters(String metaDbPath) throws Exception {
        ArrayList<MetaDbSearchClassFilterBean> result = new ArrayList<MetaDbSearchClassFilterBean>();
        try {
            String[] propertyEntryKeys = this.metaDb.listSimplePropertyEntry(metaDbPath);
            int len = propertyEntryKeys != null ? propertyEntryKeys.length : -1;
            for (int i = 0; i < len; ++i) {
                boolean insert;
                MetaDbSearchClassFilterBean fb = new MetaDbSearchClassFilterBean();
                String val = this.metaDb.getSimplePropertyValue(metaDbPath + "/" + propertyEntryKeys[i])[0];
                if (val == null || val.length() == 0) {
                    val = "false";
                }
                if (!(insert = Boolean.valueOf(val).booleanValue())) continue;
                ClassObjectClientBean cocb = this.sessionController.getClassObject(propertyEntryKeys[i]);
                fb.setClassName(propertyEntryKeys[i]);
                fb.setClassId("" + cocb.getId());
                result.add(fb);
            }
        }
        catch (MetaDbException e) {
            e.printStackTrace(System.err);
        }
        return result;
    }
}

