/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.common.Startup;
import agorum.roi.common.utils.InstallUtil;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.parser.mail.EmlParser;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.workers.QueryWorker;
import java.util.Map;

public class MailCompressor
extends QueryWorker {
    private static final String METADB_CONCURRENCY = "MAIN_MODULE_MANAGEMENT/workers/MailCompressor/Concurrency";
    private static final String METADB_QUERY = "MAIN_MODULE_MANAGEMENT/workers/MailCompressor/Query";
    private static final int DEFAULT_CONCURRENCY = 0;
    private static final String[] PROPERTIES = new String[]{"uuid"};
    private static final MailCompressor instance = new MailCompressor();
    private String query;

    private MailCompressor() {
        super("MailCompressor", SessionControllerAdmin.getService(MailCompressor.class).getMetaDbInstance().getInt(METADB_CONCURRENCY, 0));
        MailCompressor.ifCompatible(() -> {
            MailCompressor.reconfigure();
            this.start();
        });
    }

    public static void ifCompatible(Runnable callback) {
        Startup.whenReady(() -> {
            if (IndexHelper.supportsAdvancedSearch()) {
                InstallUtil.ifModuleActive("MailCompression", callback);
            }
        });
    }

    public static void ifNotCompatible(Runnable callback) {
        Startup.whenReady(() -> {
            if (IndexHelper.supportsAdvancedSearch()) {
                InstallUtil.ifModuleNotActive("MailCompression", callback);
            } else {
                callback.run();
            }
        });
    }

    public static void reconfigure() {
        MetaDb mdb = SessionControllerAdmin.getService(MailCompressor.class).getMetaDbInstance();
        instance.setQuery(mdb.getString(METADB_QUERY));
        instance.setConcurrency(mdb.getInt(METADB_CONCURRENCY, 0));
    }

    @Override
    protected boolean includeHidden() {
        return true;
    }

    private void setQuery(String query) {
        this.query = query == null || query.trim().isEmpty() ? null : "(" + query + ") (ismailattachment:true OR ismailbody:true) NOT systemflag:(2 OR 131072 OR 262144)";
    }

    @Override
    protected String getQuery() {
        return this.query;
    }

    @Override
    protected String[] getProperties() {
        return PROPERTIES;
    }

    @Override
    protected String getId(Map<String, AttributeInfo> item) {
        return (String)item.get((Object)"uuid").value;
    }

    @Override
    protected void work(Map<String, AttributeInfo> item) {
        Long objectId = null;
        try {
            GlobalObjectClientBean object = SessionControllerAdmin.getService(MailCompressor.class).getGlobalObjectByUUID((String)item.get((Object)"uuid").value);
            objectId = object.getId();
            EmlParser.compress(object);
        }
        catch (Exception e) {
            this.stat.error().sticky(this.getName()).objectId(objectId).exception((Throwable)e).send("Error while executing mail compressor");
        }
    }
}

