/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.commons.statistic.Statistic;
import agorum.roi.common.Startup;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.workers.Job;
import agorum.roi.workers.Queue;
import agorum.roi.workers.Worker;
import java.util.Collection;

public class ReindexWorker
extends Worker {
    private static final String METADB_CONCURRENCY = "MAIN_MODULE_MANAGEMENT/workers/ReindexWorker/Concurrency";
    private static final ReindexWorker instance = new ReindexWorker();
    private final Queue queue;

    public static void queue(GlobalObjectClientBean object) throws Exception {
        ReindexWorker.instance.queue.queue(object.getId(), null, () -> instance.wake());
    }

    protected ReindexWorker() {
        super("ReindexWorker", SessionControllerAdmin.getService(ReindexWorker.class).getMetaDbInstance().getInt(METADB_CONCURRENCY, 1));
        this.queue = new Queue((Statistic)this.stat, "ReindexQueue", item -> {
            try (Transaction t = new Transaction();){
                this.activateReindex(item.getObject());
                item.done();
                t.commit();
            }
        });
        Startup.whenReady(() -> this.start());
    }

    @Override
    protected Collection<Job> collect(int limit, boolean idle) {
        return this.queue.collect(limit);
    }

    private void activateReindex(GlobalObjectClientBean gocb) throws Exception {
        MessageUtils mu = new MessageUtils();
        mu.sendUpdateEvent(gocb, gocb.getDefinition(gocb.getSessionController()));
        if (gocb instanceof DirectoryGroupObjectClientBean) {
            DirectoryGroupObjectClientBean dgocb = (DirectoryGroupObjectClientBean)gocb;
            for (DirectoryObjectClientBean member : dgocb.getAllMembers()) {
                this.activateReindex(member);
            }
        }
    }
}

