/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.commons.statistic.SystemStatistic;
import agorum.roi.statistic.workers.WorkersSubStatistic;
import agorum.roi.workers.Job;
import agorum.roi.workers.Workers;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class Worker {
    private static final long IDLE_TIMEOUT = 10000L;
    private static final long MIN_CYCLE_TIME = 1000L;
    private static final int JOBS_PER_THREAD = 150;
    private final String name;
    private int concurrency;
    private final ThreadPoolExecutor pool;
    private final CompletionService<?> service;
    private boolean active;
    private int capacity;
    private int pending;
    private final Object signal = new Object();
    protected final SystemStatistic stat;

    protected Worker(String name, int concurrency) {
        if (name == null) {
            throw new NullPointerException("Worker name may not be null");
        }
        this.name = name;
        Workers.put(name, this);
        this.concurrency = concurrency;
        this.pool = new ThreadPoolExecutor(Math.max(concurrency, 1), Math.max(concurrency, 1), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.service = new ExecutorCompletionService(this.pool);
        this.stat = WorkersSubStatistic.getInstance(name);
    }

    public String getName() {
        return this.name;
    }

    public final synchronized void setConcurrency(int concurrency) {
        if (concurrency == this.concurrency) {
            return;
        }
        if (concurrency > this.concurrency) {
            this.pool.setMaximumPoolSize(Math.max(concurrency, 1));
            this.pool.setCorePoolSize(Math.max(concurrency, 1));
        } else {
            this.pool.setCorePoolSize(Math.max(concurrency, 1));
            this.pool.setMaximumPoolSize(Math.max(concurrency, 1));
        }
        this.concurrency = concurrency;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getPending() {
        return this.pending;
    }

    public void start() {
        if (!this.active) {
            this.active = true;
            new Thread(() -> this.run(), this.name).start();
        }
    }

    public void stop() {
        this.active = false;
    }

    public void remove() {
        this.stop();
        Workers.remove(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            IdentityHashMap pending = new IdentityHashMap();
            HashSet<String> pendingIds = new HashSet<String>();
            long nextCycleStart = 0L;
            boolean idle = true;
            while (this.active) {
                if (this.concurrency <= 0) {
                    this.stat.debug("Deactivated, sitting idle");
                    this.idle();
                    continue;
                }
                long now = System.currentTimeMillis();
                if (nextCycleStart > now) {
                    try {
                        Thread.sleep(nextCycleStart - now);
                    }
                    catch (InterruptedException e) {
                        this.stat.warning((Throwable)e, "Interrupted while throttling");
                    }
                }
                nextCycleStart = System.currentTimeMillis() + 1000L;
                this.stat.debug("Collecting jobs");
                this.capacity = this.concurrency * 150;
                int free = this.capacity - pending.size();
                if (free > 0) {
                    for (Job job : this.collect(free, idle)) {
                        this.stat.debug("Considering job: " + job.id);
                        if (pendingIds.add(job.id)) {
                            this.stat.debug("Submitting job: " + job.id);
                            pending.put(this.service.submit(job.worker, null), job.id);
                            continue;
                        }
                        this.stat.debug("Job still pending: " + job.id);
                    }
                }
                int waiting = this.pending = pending.size();
                idle = false;
                if (waiting <= 0) {
                    this.stat.debug("No work, sitting idle");
                    idle = true;
                    this.idle();
                    continue;
                }
                if (waiting < this.concurrency) {
                    Future<?> work;
                    this.stat.debug("Not enough work, sitting idle");
                    this.idle();
                    while ((work = this.service.poll()) != null) {
                        this.finish(work, pending, pendingIds);
                    }
                    continue;
                }
                this.stat.debug(waiting + " jobs pending");
                int waitFor = Math.max(1, waiting / 3 * 2);
                this.stat.debug("Waiting for " + waitFor + " jobs to finish");
                for (int i = 0; i < waitFor && this.active; ++i) {
                    try {
                        this.finish(this.service.take(), pending, pendingIds);
                        continue;
                    }
                    catch (InterruptedException e) {
                        this.stat.warning((Throwable)e, "Interrupted while waiting");
                    }
                }
            }
        }
        finally {
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wake() {
        Object object = this.signal;
        synchronized (object) {
            this.signal.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idle() {
        Object object = this.signal;
        synchronized (object) {
            try {
                this.signal.wait(10000L);
            }
            catch (InterruptedException e) {
                this.stat.warning((Throwable)e, "Interrupted while idling");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(Future<?> work, Map<Future<?>, String> pending, Set<String> pendingIds) {
        try {
            work.get();
        }
        catch (Exception e) {
            this.stat.error((Throwable)e, "Worker threw unchecked exception");
        }
        finally {
            String id = pending.remove(work);
            this.stat.debug("Job finished: " + id);
            this.stat.count("Jobs run", 1L);
            pendingIds.remove(id);
        }
    }

    public void reset() {
    }

    protected abstract Collection<Job> collect(int var1, boolean var2);
}

