/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.common.Startup;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.statistic.workers.WorkersStatistic;
import agorum.roi.workers.Worker;
import java.util.HashMap;
import java.util.Map;

public class Workers {
    private static final Map<String, Worker> instances = new HashMap<String, Worker>();
    private static final WorkersStatistic stat = WorkersStatistic.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void put(String name, Worker worker) {
        Map<String, Worker> map = instances;
        synchronized (map) {
            if (instances.containsKey(name)) {
                throw new IllegalArgumentException("Worker name already in use: " + name);
            }
            instances.put(name, worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(String name) {
        Map<String, Worker> map = instances;
        synchronized (map) {
            instances.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Worker get(String name) {
        Map<String, Worker> map = instances;
        synchronized (map) {
            return instances.get(name);
        }
    }

    static {
        Startup.whenReady(() -> {
            MetaDb metaDb = SessionControllerAdmin.getService(Workers.class).getMetaDbInstance();
            for (String worker : metaDb.listBundles("MAIN_MODULE_MANAGEMENT/workers")) {
                try {
                    Class.forName(metaDb.getString("MAIN_MODULE_MANAGEMENT/workers/" + worker + "/Class"));
                }
                catch (Exception e) {
                    stat.error().exception((Throwable)e).send("Could not start worker: " + worker);
                }
            }
        });
    }
}

