/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers.sample;

import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.workers.QueryWorker;
import java.util.Map;

public class MetadataRenamer
extends QueryWorker {
    private final String oldName;
    private final String newName;
    private final String[] properties;

    public MetadataRenamer(String name, int poolSize, String oldName, String newName) {
        super("MetadataRenamer-" + name, poolSize);
        this.oldName = oldName.toLowerCase();
        this.newName = newName;
        this.properties = new String[]{"uuid", oldName};
    }

    @Override
    protected boolean includeHidden() {
        return false;
    }

    @Override
    protected String getQuery() {
        return this.oldName + ":*";
    }

    @Override
    protected String[] getProperties() {
        return this.properties;
    }

    @Override
    protected String getId(Map<String, AttributeInfo> item) {
        return (String)item.get((Object)"uuid").value;
    }

    @Override
    protected void work(Map<String, AttributeInfo> item) {
        Object value = item.get((Object)this.oldName).value;
        Long objectId = null;
        try {
            GlobalObjectClientBean object = SessionControllerAdmin.getService(MetadataRenamer.class).getGlobalObjectByUUID((String)item.get((Object)"uuid").value);
            objectId = object.getId();
            object.setExtendedAttribute(this.newName, value);
            object.setExtendedAttribute(this.oldName, null);
            object.saveExtendedAttributes();
        }
        catch (Exception e) {
            this.stat.error().sticky(this.getName()).objectId(objectId).exception((Throwable)e).send("Error while renaming metadata");
        }
    }
}

