/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLAuthentication;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;

enum X509Authentication implements SSLAuthentication
{
    RSA("RSA", "RSA"),
    RSASSA_PSS("RSASSA-PSS", "RSASSA-PSS"),
    RSA_OR_PSS("RSA_OR_PSS", "RSA", "RSASSA-PSS"),
    DSA("DSA", "DSA"),
    EC("EC", "EC");

    final String keyAlgorithm;
    final String[] keyTypes;

    private X509Authentication(String string2, String ... stringArray) {
        this.keyAlgorithm = string2;
        this.keyTypes = stringArray;
    }

    static X509Authentication valueOf(SignatureScheme signatureScheme) {
        for (X509Authentication x509Authentication : X509Authentication.values()) {
            if (!x509Authentication.keyAlgorithm.equals(signatureScheme.keyAlgorithm)) continue;
            return x509Authentication;
        }
        return null;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return X509Authentication.createPossession(handshakeContext, this.keyTypes);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_REQUEST};
        }
        return new SSLHandshake[0];
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLHandshake>(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE)};
        }
        return new Map.Entry[0];
    }

    public static SSLPossession createPossession(HandshakeContext handshakeContext, String[] stringArray) {
        if (handshakeContext.sslConfig.isClientMode) {
            return X509Authentication.createClientPossession((ClientHandshakeContext)handshakeContext, stringArray);
        }
        return X509Authentication.createServerPossession((ServerHandshakeContext)handshakeContext, stringArray);
    }

    private static SSLPossession createClientPossession(ClientHandshakeContext clientHandshakeContext, String[] stringArray) {
        X509ExtendedKeyManager x509ExtendedKeyManager = clientHandshakeContext.sslContext.getX509KeyManager();
        String string = null;
        if (clientHandshakeContext.conContext.transport instanceof SSLSocketImpl) {
            string = x509ExtendedKeyManager.chooseClientAlias(stringArray, clientHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])clientHandshakeContext.peerSupportedAuthorities.clone(), (SSLSocket)((Object)clientHandshakeContext.conContext.transport));
        } else if (clientHandshakeContext.conContext.transport instanceof SSLEngineImpl) {
            string = x509ExtendedKeyManager.chooseEngineClientAlias(stringArray, clientHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])clientHandshakeContext.peerSupportedAuthorities.clone(), (SSLEngine)((Object)clientHandshakeContext.conContext.transport));
        }
        if (string == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("No X.509 cert selected for " + Arrays.toString(stringArray), new Object[0]);
            }
            return null;
        }
        PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string);
        if (privateKey == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(string + " is not a private key entry", new Object[0]);
            }
            return null;
        }
        X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(string + " is a private key entry with no cert chain stored", new Object[0]);
            }
            return null;
        }
        String string2 = privateKey.getAlgorithm();
        if (!Arrays.asList(stringArray).contains(string2)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine(string + " private key algorithm " + string2 + " not in request list", new Object[0]);
            }
            return null;
        }
        String string3 = x509CertificateArray[0].getPublicKey().getAlgorithm();
        if (!string2.equals(string3)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine(string + " private or public key is not of same algorithm: " + string2 + " vs " + string3, new Object[0]);
            }
            return null;
        }
        return new X509Possession(privateKey, x509CertificateArray);
    }

    private static SSLPossession createServerPossession(ServerHandshakeContext serverHandshakeContext, String[] stringArray) {
        X509ExtendedKeyManager x509ExtendedKeyManager = serverHandshakeContext.sslContext.getX509KeyManager();
        String string = null;
        for (String string2 : stringArray) {
            if (serverHandshakeContext.conContext.transport instanceof SSLSocketImpl) {
                string = x509ExtendedKeyManager.chooseServerAlias(string2, serverHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])serverHandshakeContext.peerSupportedAuthorities.clone(), (SSLSocket)((Object)serverHandshakeContext.conContext.transport));
            } else if (serverHandshakeContext.conContext.transport instanceof SSLEngineImpl) {
                string = x509ExtendedKeyManager.chooseEngineServerAlias(string2, serverHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])serverHandshakeContext.peerSupportedAuthorities.clone(), (SSLEngine)((Object)serverHandshakeContext.conContext.transport));
            }
            if (string == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest("No X.509 cert selected for " + string2, new Object[0]);
                continue;
            }
            PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string);
            if (privateKey == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest(string + " is not a private key entry", new Object[0]);
                continue;
            }
            X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string);
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest(string + " is not a certificate entry", new Object[0]);
                continue;
            }
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            if (!privateKey.getAlgorithm().equals(string2) || !publicKey.getAlgorithm().equals(string2)) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.fine(string + " private or public key is not of " + string2 + " algorithm", new Object[0]);
                continue;
            }
            if (!serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec() && string2.equals("EC")) {
                if (!(publicKey instanceof ECPublicKey)) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.warning(string + " public key is not an instance of ECPublicKey", new Object[0]);
                    continue;
                }
                ECParameterSpec eCParameterSpec = ((ECPublicKey)publicKey).getParams();
                SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
                if (namedGroup == null || !SupportedGroupsExtension.SupportedGroups.isSupported(namedGroup) || serverHandshakeContext.clientRequestedNamedGroups != null && !serverHandshakeContext.clientRequestedNamedGroups.contains((Object)namedGroup)) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.warning("Unsupported named group (" + (Object)((Object)namedGroup) + ") used in the " + string + " certificate", new Object[0]);
                    continue;
                }
            }
            return new X509Possession(privateKey, x509CertificateArray);
        }
        return null;
    }

    static final class X509Credentials
    implements SSLCredentials {
        final X509Certificate[] popCerts;
        final PublicKey popPublicKey;

        X509Credentials(PublicKey publicKey, X509Certificate[] x509CertificateArray) {
            this.popCerts = x509CertificateArray;
            this.popPublicKey = publicKey;
        }
    }

    static final class X509Possession
    implements SSLPossession {
        final X509Certificate[] popCerts;
        final PrivateKey popPrivateKey;

        X509Possession(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.popCerts = x509CertificateArray;
            this.popPrivateKey = privateKey;
        }

        ECParameterSpec getECParameterSpec() {
            PublicKey publicKey;
            if (this.popPrivateKey == null || !"EC".equals(this.popPrivateKey.getAlgorithm())) {
                return null;
            }
            if (this.popPrivateKey instanceof ECKey) {
                return ((ECKey)((Object)this.popPrivateKey)).getParams();
            }
            if (this.popCerts != null && this.popCerts.length != 0 && (publicKey = this.popCerts[0].getPublicKey()) instanceof ECKey) {
                return ((ECKey)((Object)publicKey)).getParams();
            }
            return null;
        }
    }
}

