/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaButtonExtendedTypes;
import com.apple.laf.AquaComboBoxButton;
import com.apple.laf.AquaFocus;
import com.apple.laf.AquaMnemonicHandler;
import com.apple.laf.AquaRootPaneUI;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class AquaButtonUI
extends BasicButtonUI
implements AquaUtilControlSize.Sizeable {
    private static final String BUTTON_TYPE = "JButton.buttonType";
    private static final String SEGMENTED_BUTTON_POSITION = "JButton.segmentPosition";
    protected static final AquaUtils.RecyclableSingleton<AquaButtonUI> buttonUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaButtonUI>(AquaButtonUI.class);
    private boolean defaults_initialized = false;
    private Color defaultDisabledTextColor = null;
    static final AquaUtils.RecyclableSingleton<AquaHierarchyButtonListener> fHierListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaHierarchyButtonListener>(AquaHierarchyButtonListener.class);

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI.get();
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        String string = this.getPropertyPrefix();
        if (!this.defaults_initialized) {
            this.defaultDisabledTextColor = UIManager.getColor(string + "disabledText");
            this.defaults_initialized = true;
        }
        this.setButtonMarginIfNeeded(abstractButton, UIManager.getInsets(string + "margin"));
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installProperty(abstractButton, "opaque", UIManager.getBoolean(string + "opaque"));
        Object object2 = abstractButton.getClientProperty(BUTTON_TYPE);
        boolean bl = false;
        if (object2 != null) {
            bl = this.setButtonType(abstractButton, object2);
        }
        if (!bl) {
            this.setThemeBorder(abstractButton);
        }
        if ((object = abstractButton.getClientProperty(SEGMENTED_BUTTON_POSITION)) != null) {
            Border border = abstractButton.getBorder();
            if (!(border instanceof AquaBorder)) {
                return;
            }
            abstractButton.setBorder(AquaButtonExtendedTypes.getBorderForPosition(abstractButton, abstractButton.getClientProperty(BUTTON_TYPE), object));
        }
    }

    @Override
    public void applySizeFor(JComponent jComponent, JRSUIConstants.Size size) {
    }

    protected void setThemeBorder(AbstractButton abstractButton) {
        ButtonUI buttonUI = abstractButton.getUI();
        if (!(buttonUI instanceof AquaButtonUI)) {
            return;
        }
        AquaButtonUI aquaButtonUI = (AquaButtonUI)buttonUI;
        Border border = abstractButton.getBorder();
        if (!aquaButtonUI.isBorderFromProperty(abstractButton) && (border == null || border instanceof UIResource || border instanceof AquaButtonBorder)) {
            boolean bl = true;
            if (AquaButtonUI.isOnToolbar(abstractButton)) {
                border = abstractButton instanceof JToggleButton ? AquaButtonBorder.getToolBarButtonBorder() : AquaButtonBorder.getBevelButtonBorder();
            } else if (abstractButton.getIcon() != null || abstractButton.getComponentCount() > 0) {
                border = AquaButtonBorder.getToggleButtonBorder();
            } else {
                border = UIManager.getBorder(this.getPropertyPrefix() + "border");
                bl = false;
            }
            abstractButton.setBorder(border);
            Font font = abstractButton.getFont();
            if (bl && (font == null || font instanceof UIResource)) {
                abstractButton.setFont(UIManager.getFont("IconButton.font"));
            }
        }
    }

    protected static boolean isOnToolbar(AbstractButton abstractButton) {
        for (Container container = abstractButton.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    protected static void updateBorder(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(BUTTON_TYPE);
        if (object != null) {
            return;
        }
        ButtonUI buttonUI = abstractButton.getUI();
        if (!(buttonUI instanceof AquaButtonUI)) {
            return;
        }
        if (abstractButton.getBorder() != null) {
            ((AquaButtonUI)buttonUI).setThemeBorder(abstractButton);
        }
    }

    protected void setButtonMarginIfNeeded(AbstractButton abstractButton, Insets insets) {
        Insets insets2 = abstractButton.getMargin();
        if (insets2 == null || insets2 instanceof UIResource) {
            abstractButton.setMargin(insets);
        }
    }

    public boolean isBorderFromProperty(AbstractButton abstractButton) {
        return abstractButton.getClientProperty(BUTTON_TYPE) != null;
    }

    protected boolean setButtonType(AbstractButton abstractButton, Object object) {
        Font font;
        if (!(object instanceof String)) {
            abstractButton.putClientProperty(BUTTON_TYPE, null);
            return false;
        }
        String string = (String)object;
        boolean bl = true;
        AquaButtonExtendedTypes.TypeSpecifier typeSpecifier = AquaButtonExtendedTypes.getSpecifierByName(string);
        if (typeSpecifier != null) {
            abstractButton.setBorder(typeSpecifier.getBorder());
            bl = typeSpecifier.setIconFont;
        }
        if ((font = abstractButton.getFont()) == null || font instanceof UIResource) {
            abstractButton.setFont(UIManager.getFont(bl ? "IconButton.font" : "Button.font"));
        }
        return true;
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        AquaButtonListener aquaButtonListener = this.getAquaButtonListener(abstractButton);
        if (aquaButtonListener != null) {
            abstractButton.putClientProperty(this, aquaButtonListener);
            abstractButton.addAncestorListener(aquaButtonListener);
        }
        this.installHierListener(abstractButton);
        AquaUtilControlSize.addSizePropertyListener(abstractButton);
    }

    @Override
    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
    }

    @Override
    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        AquaButtonListener aquaButtonListener = (AquaButtonListener)abstractButton.getClientProperty(this);
        abstractButton.putClientProperty(this, null);
        if (aquaButtonListener != null) {
            abstractButton.removeAncestorListener(aquaButtonListener);
        }
        this.uninstallHierListener(abstractButton);
        AquaUtilControlSize.addSizePropertyListener(abstractButton);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
        this.defaults_initialized = false;
    }

    @Override
    protected AquaButtonListener createButtonListener(AbstractButton abstractButton) {
        return new AquaButtonListener(abstractButton);
    }

    private AquaButtonListener getAquaButtonListener(AbstractButton abstractButton) {
        MouseMotionListener[] mouseMotionListenerArray = abstractButton.getMouseMotionListeners();
        if (mouseMotionListenerArray != null) {
            for (MouseMotionListener mouseMotionListener : mouseMotionListenerArray) {
                if (!(mouseMotionListener instanceof AquaButtonListener)) continue;
                return (AquaButtonListener)mouseMotionListener;
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(abstractButton.getWidth(), abstractButton.getHeight());
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        if (abstractButton.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        AquaButtonBorder aquaButtonBorder = null;
        if (((AbstractButton)jComponent).isBorderPainted()) {
            object = jComponent.getBorder();
            if (object instanceof AquaButtonBorder) {
                aquaButtonBorder = (AquaButtonBorder)object;
                aquaButtonBorder.paintButton(jComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            if (abstractButton.isOpaque()) {
                rectangle.x = insets.left - 2;
                rectangle.y = insets.top - 2;
                rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x) + 4;
                rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y) + 4;
                if (abstractButton.isContentAreaFilled() || buttonModel.isSelected()) {
                    if (buttonModel.isSelected()) {
                        graphics.setColor(jComponent.getBackground().darker());
                    } else {
                        graphics.setColor(jComponent.getBackground());
                    }
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
            if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
                this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
            }
        }
        object = this.layoutAndGetText(graphics, abstractButton, aquaButtonBorder, insets, rectangle, rectangle2, rectangle3);
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, abstractButton, rectangle2);
        }
        if (rectangle3.width == 0) {
            rectangle3.width = 50;
        }
        if (object != null && !((String)object).equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, abstractButton, rectangle3, (String)object);
            }
        }
    }

    protected String layoutAndGetText(Graphics graphics, AbstractButton abstractButton, AquaButtonBorder aquaButtonBorder, Insets insets, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        rectangle3.height = 0;
        rectangle3.width = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        rectangle2.height = 0;
        rectangle2.width = 0;
        rectangle2.y = 0;
        rectangle2.x = 0;
        graphics.setFont(abstractButton.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = abstractButton.getText();
        String string2 = SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, string == null ? 0 : abstractButton.getIconTextGap());
        if (string2 == string || aquaButtonBorder == null) {
            return string2;
        }
        Insets insets2 = aquaButtonBorder.getContentInsets(abstractButton, abstractButton.getWidth(), abstractButton.getHeight());
        if (insets2 != null) {
            return this.layoutAndGetText(graphics, abstractButton, null, insets2, rectangle, rectangle2, rectangle3);
        }
        return string2;
    }

    protected void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (icon == null) {
            return;
        }
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 == null && icon instanceof ImageIcon) {
                icon2 = new ImageIcon(AquaUtils.generateSelectedDarkImage(((ImageIcon)icon).getImage()));
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (buttonModel.isEnabled() && abstractButton.isFocusOwner() && abstractButton.getBorder() instanceof AquaButtonBorder.Toolbar) {
            if (icon2 == null) {
                icon2 = icon;
            }
            if (icon2 instanceof ImageIcon) {
                icon2 = AquaFocus.createFocusedIcon(icon2, abstractButton, 3);
                icon2.paintIcon(abstractButton, graphics, rectangle.x - 3, rectangle.y - 3);
                return;
            }
        }
        if (icon2 != null) {
            icon = icon2;
        }
        icon.paintIcon(abstractButton, graphics, rectangle.x, rectangle.y);
    }

    @Override
    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        int n;
        Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = n = AquaMnemonicHandler.isMnemonicHidden() ? -1 : abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
        } else {
            graphics.setColor(this.defaultDisabledTextColor);
        }
        SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.paint(graphics, abstractButton);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
        if (dimension == null) {
            return null;
        }
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            ((AquaButtonBorder)border).alterPreferredSize(dimension);
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    static AquaHierarchyButtonListener getAquaHierarchyButtonListener() {
        return fHierListener.get();
    }

    private boolean shouldInstallHierListener(AbstractButton abstractButton) {
        return abstractButton instanceof JButton || abstractButton instanceof JToggleButton && !(abstractButton instanceof AquaComboBoxButton) && !(abstractButton instanceof JCheckBox) && !(abstractButton instanceof JRadioButton);
    }

    protected void installHierListener(AbstractButton abstractButton) {
        if (this.shouldInstallHierListener(abstractButton)) {
            abstractButton.addHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    protected void uninstallHierListener(AbstractButton abstractButton) {
        if (this.shouldInstallHierListener(abstractButton)) {
            abstractButton.removeHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    class AquaButtonListener
    extends BasicButtonListener
    implements AncestorListener {
        protected final AbstractButton b;

        public AquaButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            this.b = abstractButton;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ((Component)focusEvent.getSource()).repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ((Component)focusEvent.getSource()).repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Border border;
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if ("Frame.active".equals(string)) {
                this.b.repaint();
                return;
            }
            if ("icon".equals(string) || "text".equals(string)) {
                AquaButtonUI.this.setThemeBorder(this.b);
                return;
            }
            if (AquaButtonUI.BUTTON_TYPE.equals(string)) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                Border border2 = AquaButtonExtendedTypes.getBorderForPosition(this.b, string2, this.b.getClientProperty(AquaButtonUI.SEGMENTED_BUTTON_POSITION));
                if (border2 != null) {
                    this.b.setBorder(border2);
                }
                return;
            }
            if (AquaButtonUI.SEGMENTED_BUTTON_POSITION.equals(string)) {
                border = this.b.getBorder();
                if (!(border instanceof AquaBorder)) {
                    return;
                }
                this.b.setBorder(AquaButtonExtendedTypes.getBorderForPosition(this.b, this.b.getClientProperty(AquaButtonUI.BUTTON_TYPE), propertyChangeEvent.getNewValue()));
            }
            if ("componentOrientation".equals(string)) {
                border = this.b.getBorder();
                if (!(border instanceof AquaBorder)) {
                    return;
                }
                Object object = this.b.getClientProperty(AquaButtonUI.BUTTON_TYPE);
                Object object2 = this.b.getClientProperty(AquaButtonUI.SEGMENTED_BUTTON_POSITION);
                if (object != null && object2 != null) {
                    this.b.setBorder(AquaButtonExtendedTypes.getBorderForPosition(this.b, object, object2));
                }
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.updateDefaultButton();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            this.updateDefaultButton();
        }

        protected void updateDefaultButton() {
            if (!(this.b instanceof JButton)) {
                return;
            }
            if (!((JButton)this.b).isDefaultButton()) {
                return;
            }
            JRootPane jRootPane = this.b.getRootPane();
            if (jRootPane == null) {
                return;
            }
            RootPaneUI rootPaneUI = jRootPane.getUI();
            if (!(rootPaneUI instanceof AquaRootPaneUI)) {
                return;
            }
            ((AquaRootPaneUI)rootPaneUI).updateDefaultButton(jRootPane);
        }
    }

    static class AquaHierarchyButtonListener
    implements HierarchyListener {
        AquaHierarchyButtonListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 1L) == 0L) {
                return;
            }
            Object object = hierarchyEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)object;
            ButtonUI buttonUI = abstractButton.getUI();
            if (!(buttonUI instanceof AquaButtonUI)) {
                return;
            }
            if (!(abstractButton.getBorder() instanceof UIResource)) {
                return;
            }
            ((AquaButtonUI)buttonUI).setThemeBorder(abstractButton);
        }
    }
}

