/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.BufferManagerRead;
import com.sun.corba.se.impl.encoding.BufferQueue;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.MarkAndResetHandler;
import com.sun.corba.se.impl.encoding.RestorableInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.RequestCanceledException;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.pept.transport.ByteBufferPool;
import com.sun.corba.se.spi.orb.ORB;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.ListIterator;

public class BufferManagerReadStream
implements BufferManagerRead,
MarkAndResetHandler {
    private boolean receivedCancel = false;
    private int cancelReqId = 0;
    private boolean endOfStream = true;
    private BufferQueue fragmentQueue = new BufferQueue();
    private long FRAGMENT_TIMEOUT = 60000L;
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private boolean debug = false;
    private boolean markEngaged = false;
    private LinkedList fragmentStack = null;
    private RestorableInputStream inputStream = null;
    private Object streamMemento = null;

    BufferManagerReadStream(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.encoding");
        this.debug = oRB.transportDebugFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelProcessing(int n) {
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            this.receivedCancel = true;
            this.cancelReqId = n;
            this.fragmentQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFragment(ByteBuffer byteBuffer, FragmentMessage fragmentMessage) {
        ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo((org.omg.CORBA.ORB)this.orb, byteBuffer, fragmentMessage.getHeaderLength());
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            if (this.debug) {
                int n = System.identityHashCode(byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append("processFragment() - queueing ByteBuffer id (");
                stringBuffer.append(n).append(") to fragment queue.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
            this.fragmentQueue.enqueue(byteBufferWithInfo);
            this.endOfStream = !fragmentMessage.moreFragmentsToFollow();
            this.fragmentQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBufferWithInfo underflow(ByteBufferWithInfo byteBufferWithInfo) {
        ByteBufferWithInfo byteBufferWithInfo2 = null;
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            CharSequence charSequence;
            if (this.receivedCancel) {
                throw new RequestCanceledException(this.cancelReqId);
            }
            long l = System.currentTimeMillis() + this.FRAGMENT_TIMEOUT;
            long l2 = this.FRAGMENT_TIMEOUT;
            while (this.fragmentQueue.size() == 0) {
                block13: {
                    if (this.endOfStream) {
                        throw this.wrapper.endOfStream();
                    }
                    if (l2 <= 0L) {
                        throw this.wrapper.bufferReadManagerTimeout();
                    }
                    if (this.debug && l2 != this.FRAGMENT_TIMEOUT) {
                        this.dprint("underflow() - new wait call required with value: " + l2);
                    }
                    try {
                        this.fragmentQueue.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.debug) break block13;
                        this.dprint("underflow() - fragment queue wait timeout interrupted");
                    }
                }
                l2 = l - System.currentTimeMillis();
                if (!this.receivedCancel) continue;
                throw new RequestCanceledException(this.cancelReqId);
            }
            byteBufferWithInfo2 = this.fragmentQueue.dequeue();
            byteBufferWithInfo2.fragmented = true;
            if (this.debug) {
                int n = System.identityHashCode(byteBufferWithInfo2.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append("underflow() - dequeued ByteBuffer id (");
                stringBuffer.append(n).append(") from fragment queue.");
                charSequence = stringBuffer.toString();
                this.dprint((String)charSequence);
            }
            if (!this.markEngaged && byteBufferWithInfo != null && byteBufferWithInfo.byteBuffer != null) {
                ByteBufferPool byteBufferPool = this.getByteBufferPool();
                if (this.debug) {
                    int n = System.identityHashCode(byteBufferWithInfo.byteBuffer);
                    charSequence = new StringBuffer(80);
                    ((StringBuffer)charSequence).append("underflow() - releasing ByteBuffer id (");
                    ((StringBuffer)charSequence).append(n).append(") to ByteBufferPool.");
                    String string = ((StringBuffer)charSequence).toString();
                    this.dprint(string);
                }
                byteBufferPool.releaseByteBuffer(byteBufferWithInfo.byteBuffer);
                byteBufferWithInfo.byteBuffer = null;
                byteBufferWithInfo = null;
            }
        }
        return byteBufferWithInfo2;
    }

    @Override
    public void init(Message message) {
        if (message != null) {
            this.endOfStream = !message.moreFragmentsToFollow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(ByteBufferWithInfo byteBufferWithInfo) {
        String string;
        StringBuffer stringBuffer;
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2 = 0;
        if (this.fragmentQueue != null) {
            object3 = this.fragmentQueue;
            synchronized (object3) {
                if (byteBufferWithInfo != null) {
                    n2 = System.identityHashCode(byteBufferWithInfo.byteBuffer);
                }
                object2 = null;
                object = this.getByteBufferPool();
                while (this.fragmentQueue.size() != 0) {
                    object2 = this.fragmentQueue.dequeue();
                    if (object2 == null || ((ByteBufferWithInfo)object2).byteBuffer == null) continue;
                    n = System.identityHashCode(((ByteBufferWithInfo)object2).byteBuffer);
                    if (n2 != n && this.debug) {
                        stringBuffer = new StringBuffer(80);
                        stringBuffer.append("close() - fragmentQueue is ").append("releasing ByteBuffer id (").append(n).append(") to ").append("ByteBufferPool.");
                        string = stringBuffer.toString();
                        this.dprint(string);
                    }
                    object.releaseByteBuffer(((ByteBufferWithInfo)object2).byteBuffer);
                }
            }
            this.fragmentQueue = null;
        }
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            if (byteBufferWithInfo != null) {
                n2 = System.identityHashCode(byteBufferWithInfo.byteBuffer);
            }
            object3 = null;
            object2 = this.getByteBufferPool();
            object = this.fragmentStack.listIterator();
            while (object.hasNext()) {
                object3 = (ByteBufferWithInfo)object.next();
                if (object3 == null || ((ByteBufferWithInfo)object3).byteBuffer == null || n2 == (n = System.identityHashCode(((ByteBufferWithInfo)object3).byteBuffer))) continue;
                if (this.debug) {
                    stringBuffer = new StringBuffer(80);
                    stringBuffer.append("close() - fragmentStack - releasing ").append("ByteBuffer id (" + n + ") to ").append("ByteBufferPool.");
                    string = stringBuffer.toString();
                    this.dprint(string);
                }
                object2.releaseByteBuffer(((ByteBufferWithInfo)object3).byteBuffer);
            }
            this.fragmentStack = null;
        }
    }

    protected ByteBufferPool getByteBufferPool() {
        return this.orb.getByteBufferPool();
    }

    private void dprint(String string) {
        ORBUtility.dprint("BufferManagerReadStream", string);
    }

    @Override
    public void mark(RestorableInputStream restorableInputStream) {
        this.inputStream = restorableInputStream;
        this.markEngaged = true;
        this.streamMemento = restorableInputStream.createStreamMemento();
        if (this.fragmentStack != null) {
            this.fragmentStack.clear();
        }
    }

    @Override
    public void fragmentationOccured(ByteBufferWithInfo byteBufferWithInfo) {
        if (!this.markEngaged) {
            return;
        }
        if (this.fragmentStack == null) {
            this.fragmentStack = new LinkedList();
        }
        this.fragmentStack.addFirst(new ByteBufferWithInfo(byteBufferWithInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this.markEngaged) {
            return;
        }
        this.markEngaged = false;
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            ListIterator listIterator = this.fragmentStack.listIterator();
            BufferQueue bufferQueue = this.fragmentQueue;
            synchronized (bufferQueue) {
                while (listIterator.hasNext()) {
                    this.fragmentQueue.push((ByteBufferWithInfo)listIterator.next());
                }
            }
            this.fragmentStack.clear();
        }
        this.inputStream.restoreInternalState(this.streamMemento);
    }

    @Override
    public MarkAndResetHandler getMarkAndResetHandler() {
        return this;
    }
}

