/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SKIResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(X509SKIResolver.class);

    @Override
    protected boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            return false;
        }
        Element[] elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SKI");
        return elementArray != null && elementArray.length > 0;
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver, bl);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        Element[] elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SKI");
        if (elementArray == null || elementArray.length <= 0) {
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SKI"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                LOG.debug("", keyResolverException);
                throw keyResolverException;
            }
            XMLX509SKI[] xMLX509SKIArray = new XMLX509SKI[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509SKIArray[i] = new XMLX509SKI(elementArray[i], string);
            }
            Iterator<Certificate> iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                XMLX509SKI xMLX509SKI = new XMLX509SKI(element.getOwnerDocument(), x509Certificate);
                for (XMLX509SKI xMLX509SKI2 : xMLX509SKIArray) {
                    if (!xMLX509SKI.equals(xMLX509SKI2)) continue;
                    LOG.debug("Return PublicKey from {}", x509Certificate.getSubjectX500Principal().getName());
                    return x509Certificate;
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyResolverException(xMLSecurityException);
        }
        return null;
    }

    @Override
    protected SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }

    @Override
    protected PrivateKey engineResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }
}

