/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.List;
import sun.security.jca.GetInstance;
import sun.security.jca.JCAUtil;
import sun.security.util.Debug;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("keypairgenerator");
    private final String algorithm;
    Provider provider;

    protected KeyPairGenerator(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    private static KeyPairGenerator getInstance(GetInstance.Instance instance, String string) {
        KeyPairGenerator keyPairGenerator;
        if (instance.impl instanceof KeyPairGenerator) {
            keyPairGenerator = (KeyPairGenerator)instance.impl;
        } else {
            KeyPairGeneratorSpi keyPairGeneratorSpi = (KeyPairGeneratorSpi)instance.impl;
            keyPairGenerator = new Delegate(keyPairGeneratorSpi, string);
        }
        keyPairGenerator.provider = instance.provider;
        if (!skipDebug && pdebug != null) {
            pdebug.println("KeyPairGenerator." + string + " algorithm from: " + keyPairGenerator.provider.getName());
        }
        return keyPairGenerator;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices("KeyPairGenerator", string);
        Iterator<Provider.Service> iterator = list.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchAlgorithmException(string + " KeyPairGenerator not available");
        }
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        while (true) {
            Provider.Service service = iterator.next();
            try {
                GetInstance.Instance instance = GetInstance.getInstance(service, KeyPairGeneratorSpi.class);
                if (instance.impl instanceof KeyPairGenerator) {
                    return KeyPairGenerator.getInstance(instance, string);
                }
                return new Delegate(instance, iterator, string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                if (noSuchAlgorithmException != null) continue;
                noSuchAlgorithmException = noSuchAlgorithmException2;
                if (iterator.hasNext()) continue;
                throw noSuchAlgorithmException;
            }
            break;
        }
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("KeyPairGenerator", KeyPairGeneratorSpi.class, string, string2);
        return KeyPairGenerator.getInstance(instance, string);
    }

    public static KeyPairGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("KeyPairGenerator", KeyPairGeneratorSpi.class, string, provider);
        return KeyPairGenerator.getInstance(instance, string);
    }

    public final Provider getProvider() {
        this.disableFailover();
        return this.provider;
    }

    void disableFailover() {
    }

    public void initialize(int n) {
        this.initialize(n, JCAUtil.getDefSecureRandom());
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, JCAUtil.getDefSecureRandom());
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
    }

    public final KeyPair genKeyPair() {
        return this.generateKeyPair();
    }

    @Override
    public KeyPair generateKeyPair() {
        return null;
    }

    private static final class Delegate
    extends KeyPairGenerator {
        private volatile KeyPairGeneratorSpi spi;
        private final Object lock = new Object();
        private Iterator<Provider.Service> serviceIterator;
        private static final int I_NONE = 1;
        private static final int I_SIZE = 2;
        private static final int I_PARAMS = 3;
        private int initType;
        private int initKeySize;
        private AlgorithmParameterSpec initParams;
        private SecureRandom initRandom;

        Delegate(KeyPairGeneratorSpi keyPairGeneratorSpi, String string) {
            super(string);
            this.spi = keyPairGeneratorSpi;
        }

        Delegate(GetInstance.Instance instance, Iterator<Provider.Service> iterator, String string) {
            super(string);
            this.spi = (KeyPairGeneratorSpi)instance.impl;
            this.provider = instance.provider;
            this.serviceIterator = iterator;
            this.initType = 1;
            if (!skipDebug && pdebug != null) {
                pdebug.println("KeyPairGenerator." + string + " algorithm from: " + this.provider.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyPairGeneratorSpi nextSpi(KeyPairGeneratorSpi keyPairGeneratorSpi, boolean bl) {
            Object object = this.lock;
            synchronized (object) {
                if (keyPairGeneratorSpi != null && keyPairGeneratorSpi != this.spi) {
                    return this.spi;
                }
                if (this.serviceIterator == null) {
                    return null;
                }
                while (this.serviceIterator.hasNext()) {
                    Provider.Service service = this.serviceIterator.next();
                    try {
                        Object object2 = service.newInstance(null);
                        if (!(object2 instanceof KeyPairGeneratorSpi) || object2 instanceof KeyPairGenerator) continue;
                        KeyPairGeneratorSpi keyPairGeneratorSpi2 = (KeyPairGeneratorSpi)object2;
                        if (bl) {
                            if (this.initType == 2) {
                                keyPairGeneratorSpi2.initialize(this.initKeySize, this.initRandom);
                            } else if (this.initType == 3) {
                                keyPairGeneratorSpi2.initialize(this.initParams, this.initRandom);
                            } else if (this.initType != 1) {
                                throw new AssertionError((Object)("KeyPairGenerator initType: " + this.initType));
                            }
                        }
                        this.provider = service.getProvider();
                        this.spi = keyPairGeneratorSpi2;
                        return keyPairGeneratorSpi2;
                    }
                    catch (Exception exception) {
                    }
                }
                this.disableFailover();
                return null;
            }
        }

        @Override
        void disableFailover() {
            this.serviceIterator = null;
            this.initType = 0;
            this.initParams = null;
            this.initRandom = null;
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            if (this.serviceIterator == null) {
                this.spi.initialize(n, secureRandom);
                return;
            }
            RuntimeException runtimeException = null;
            KeyPairGeneratorSpi keyPairGeneratorSpi = this.spi;
            while (true) {
                try {
                    keyPairGeneratorSpi.initialize(n, secureRandom);
                    this.initType = 2;
                    this.initKeySize = n;
                    this.initParams = null;
                    this.initRandom = secureRandom;
                    return;
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException != null) continue;
                    runtimeException = runtimeException2;
                    if ((keyPairGeneratorSpi = this.nextSpi(keyPairGeneratorSpi, false)) != null) continue;
                    throw runtimeException;
                }
                break;
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (this.serviceIterator == null) {
                this.spi.initialize(algorithmParameterSpec, secureRandom);
                return;
            }
            Exception exception = null;
            KeyPairGeneratorSpi keyPairGeneratorSpi = this.spi;
            while (true) {
                try {
                    keyPairGeneratorSpi.initialize(algorithmParameterSpec, secureRandom);
                    this.initType = 3;
                    this.initKeySize = 0;
                    this.initParams = algorithmParameterSpec;
                    this.initRandom = secureRandom;
                    return;
                }
                catch (Exception exception2) {
                    if (exception != null) continue;
                    exception = exception2;
                    if ((keyPairGeneratorSpi = this.nextSpi(keyPairGeneratorSpi, false)) != null) continue;
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw (InvalidAlgorithmParameterException)exception;
                }
                break;
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (this.serviceIterator == null) {
                return this.spi.generateKeyPair();
            }
            RuntimeException runtimeException = null;
            KeyPairGeneratorSpi keyPairGeneratorSpi = this.spi;
            while (true) {
                try {
                    return keyPairGeneratorSpi.generateKeyPair();
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException != null) continue;
                    runtimeException = runtimeException2;
                    if ((keyPairGeneratorSpi = this.nextSpi(keyPairGeneratorSpi, true)) != null) continue;
                    throw runtimeException;
                }
                break;
            }
        }
    }
}

