/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.JTabbedPane;
import sun.lwawt.macosx.CFRetainedResource;

class CAccessible
extends CFRetainedResource
implements Accessible {
    private static Field nativeAXResourceField = CAccessible.getNativeAXResourceField();
    private Accessible accessible;
    private AccessibleContext activeDescendant;

    static Field getNativeAXResourceField() {
        try {
            Field field = AccessibleContext.class.getDeclaredField("nativeAXResource");
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static CAccessible getCAccessible(Accessible accessible) {
        if (accessible == null) {
            return null;
        }
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        try {
            CAccessible cAccessible = (CAccessible)nativeAXResourceField.get(accessibleContext);
            if (cAccessible != null) {
                return cAccessible;
            }
            CAccessible cAccessible2 = new CAccessible(accessible);
            nativeAXResourceField.set(accessibleContext, cAccessible2);
            return cAccessible2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static native void unregisterFromCocoaAXSystem(long var0);

    private static native void valueChanged(long var0);

    private static native void selectedTextChanged(long var0);

    private static native void selectionChanged(long var0);

    private static native void titleChanged(long var0);

    private static native void menuOpened(long var0);

    private static native void menuClosed(long var0);

    private static native void menuItemSelected(long var0);

    private static native void treeNodeExpanded(long var0);

    private static native void treeNodeCollapsed(long var0);

    private static native void selectedCellsChanged(long var0);

    private static native void tableContentCacheClear(long var0);

    private CAccessible(Accessible accessible) {
        super(0L, true);
        if (accessible == null) {
            throw new NullPointerException();
        }
        this.accessible = accessible;
        if (accessible instanceof Component) {
            this.addNotificationListeners((Component)((Object)accessible));
        }
    }

    @Override
    protected synchronized void dispose() {
        if (this.ptr != 0L) {
            CAccessible.unregisterFromCocoaAXSystem(this.ptr);
        }
        super.dispose();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessible.getAccessibleContext();
    }

    public void addNotificationListeners(Component component) {
        if (component instanceof Accessible) {
            AccessibleContext accessibleContext = ((Accessible)((Object)component)).getAccessibleContext();
            accessibleContext.addPropertyChangeListener(new AXChangeNotifier());
        }
    }

    static Accessible getSwingAccessible(Accessible accessible) {
        return accessible instanceof CAccessible ? ((CAccessible)accessible).accessible : accessible;
    }

    static AccessibleContext getActiveDescendant(Accessible accessible) {
        return accessible instanceof CAccessible ? ((CAccessible)accessible).activeDescendant : null;
    }

    private class AXChangeNotifier
    implements PropertyChangeListener {
        private AXChangeNotifier() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (CAccessible.this.ptr != 0L) {
                AccessibleRole accessibleRole;
                Object object = propertyChangeEvent.getNewValue();
                Object object2 = propertyChangeEvent.getOldValue();
                if (string.compareTo("AccessibleCaret") == 0) {
                    CAccessible.selectedTextChanged(CAccessible.this.ptr);
                } else if (string.compareTo("AccessibleText") == 0) {
                    CAccessible.valueChanged(CAccessible.this.ptr);
                } else if (string.compareTo("AccessibleSelection") == 0) {
                    CAccessible.selectionChanged(CAccessible.this.ptr);
                } else if (string.compareTo("accessibleTableModelChanged") == 0) {
                    Accessible accessible;
                    AccessibleContext accessibleContext;
                    CAccessible.valueChanged(CAccessible.this.ptr);
                    if (CAccessible.getSwingAccessible(CAccessible.this) != null && (accessibleContext = (accessible = CAccessible.getSwingAccessible(CAccessible.this)).getAccessibleContext()) != null && accessibleContext.getAccessibleRole() == AccessibleRole.TABLE) {
                        CAccessible.tableContentCacheClear(CAccessible.this.ptr);
                    }
                } else if (string.compareTo("AccessibleActiveDescendant") == 0) {
                    if (object instanceof AccessibleContext) {
                        AccessibleContext accessibleContext;
                        Accessible accessible;
                        Accessible accessible2;
                        AccessibleContext accessibleContext2;
                        CAccessible.this.activeDescendant = (AccessibleContext)object;
                        if (object instanceof Accessible && (accessibleContext2 = (accessible2 = (Accessible)object).getAccessibleContext()) != null && (accessible = accessibleContext2.getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && accessibleContext.getAccessibleRole() == AccessibleRole.TABLE) {
                            CAccessible.selectedCellsChanged(CAccessible.this.ptr);
                        }
                    }
                } else if (string.compareTo("AccessibleState") == 0) {
                    AccessibleContext accessibleContext = CAccessible.this.accessible.getAccessibleContext();
                    AccessibleRole accessibleRole2 = accessibleContext.getAccessibleRole();
                    Accessible accessible = accessibleContext.getAccessibleParent();
                    AccessibleRole accessibleRole3 = null;
                    if (accessible != null) {
                        accessibleRole3 = accessible.getAccessibleContext().getAccessibleRole();
                    }
                    if (object == AccessibleState.EXPANDED) {
                        CAccessible.treeNodeExpanded(CAccessible.this.ptr);
                    } else if (object == AccessibleState.COLLAPSED) {
                        CAccessible.treeNodeCollapsed(CAccessible.this.ptr);
                    }
                    if (accessibleRole2 == AccessibleRole.POPUP_MENU) {
                        if (object != null && (AccessibleState)object == AccessibleState.VISIBLE) {
                            CAccessible.menuOpened(CAccessible.this.ptr);
                        } else if (object2 != null && (AccessibleState)object2 == AccessibleState.VISIBLE) {
                            CAccessible.menuClosed(CAccessible.this.ptr);
                        }
                    } else if ((accessibleRole2 == AccessibleRole.MENU_ITEM || accessibleRole2 == AccessibleRole.MENU) && object != null && (AccessibleState)object == AccessibleState.FOCUSED) {
                        CAccessible.menuItemSelected(CAccessible.this.ptr);
                    }
                } else if (string.compareTo("AccessibleName") == 0) {
                    if (propertyChangeEvent.getSource() instanceof JTabbedPane) {
                        CAccessible.titleChanged(CAccessible.this.ptr);
                    }
                } else if (string.compareTo("AccessibleValue") == 0 && ((accessibleRole = CAccessible.this.accessible.getAccessibleContext().getAccessibleRole()) == AccessibleRole.SLIDER || accessibleRole == AccessibleRole.PROGRESS_BAR)) {
                    CAccessible.valueChanged(CAccessible.this.ptr);
                }
            }
        }
    }
}

