/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CCursorManager;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.LWCToolkit;
import sun.security.action.GetPropertyAction;

public final class CDragSourceContextPeer
extends SunDragSourceContextPeer {
    private static final CDragSourceContextPeer fInstance = new CDragSourceContextPeer(null);
    private Image fDragImage;
    private CImage fDragCImage;
    private Point fDragImageOffset;
    private static Component hoveringComponent = null;
    private static double fMaxImageSize = 128.0;

    private CDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        super(dragGestureEvent);
    }

    public static CDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        fInstance.setTrigger(dragGestureEvent);
        return fInstance;
    }

    @Override
    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        this.fDragImage = image;
        this.fDragImageOffset = point;
        super.startDrag(dragSourceContext, cursor, image, point);
    }

    @Override
    protected void startDrag(Transferable transferable, long[] lArray, Map map) {
        long l;
        Object object;
        Point point;
        DragGestureEvent dragGestureEvent = this.getTrigger();
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        Point point2 = new Point(dragGestureEvent.getDragOrigin());
        int n = inputEvent.getModifiers() | inputEvent.getModifiersEx();
        long l2 = inputEvent.getWhen();
        int n2 = inputEvent instanceof MouseEvent ? ((MouseEvent)inputEvent).getClickCount() : 1;
        Component component = dragGestureEvent.getComponent();
        Point point3 = component.getLocation();
        Component component2 = component;
        while (!(component2 instanceof Window)) {
            point2.translate(point3.x, point3.y);
            component2 = component2.getParent();
            point3 = component2.getLocation();
        }
        if (this.fDragImage == null) {
            this.setDefaultDragImage(component);
        }
        if (this.fDragImage != null) {
            try {
                this.fDragCImage = CImage.getCreator().createFromImageImmediately(this.fDragImage);
            }
            catch (Exception exception) {
                throw new InvalidDnDOperationException("Drag image can not be created.");
            }
            if (this.fDragCImage == null) {
                throw new InvalidDnDOperationException("Drag image is not ready.");
            }
            point = this.fDragImageOffset;
        } else {
            this.fDragCImage = null;
            point = new Point(0, 0);
        }
        try {
            object = ((LWComponentPeer)component2.getPeer()).getPlatformWindow();
            l = CPlatformWindow.getNativeViewPtr((PlatformWindow)object);
            if (l == 0L) {
                throw new InvalidDnDOperationException("Unsupported platform window implementation");
            }
            long l3 = this.createNativeDragSource(component, l, transferable, inputEvent, (int)point2.getX(), (int)point2.getY(), n, n2, l2, this.fDragCImage != null ? this.fDragCImage.ptr : 0L, point.x, point.y, this.getDragSourceContext().getSourceActions(), lArray, map);
            if (l3 == 0L) {
                throw new InvalidDnDOperationException("");
            }
            this.setNativeContext(l3);
        }
        catch (Exception exception) {
            throw new InvalidDnDOperationException("failed to create native peer: " + exception);
        }
        SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
        CCursorManager.getInstance().setCursor(this.getCursor());
        try {
            object = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long l = CDragSourceContextPeer.this.getNativeContext();
                    try {
                        CDragSourceContextPeer.this.doDragging(l);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        CDragSourceContextPeer.this.releaseNativeDragSource(l);
                        CDragSourceContextPeer.this.fDragImage = null;
                        if (CDragSourceContextPeer.this.fDragCImage != null) {
                            CDragSourceContextPeer.this.fDragCImage.dispose();
                            CDragSourceContextPeer.this.fDragCImage = null;
                        }
                    }
                }
            };
            ((Thread)object).start();
        }
        catch (Exception exception) {
            l = this.getNativeContext();
            this.setNativeContext(0L);
            this.releaseNativeDragSource(l);
            SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
            throw new InvalidDnDOperationException("failed to start dragging thread: " + exception);
        }
    }

    private void setDefaultDragImage(Component component) {
        boolean bl = false;
        if (component.isLightweight()) {
            if (component instanceof JTextComponent) {
                this.setDefaultDragImage((JTextComponent)component);
                bl = true;
            } else if (component instanceof JTree) {
                this.setDefaultDragImage((JTree)component);
                bl = true;
            } else if (component instanceof JTable) {
                this.setDefaultDragImage((JTable)component);
                bl = true;
            } else if (component instanceof JList) {
                this.setDefaultDragImage((JList)component);
                bl = true;
            }
        }
        if (!bl) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTextComponent jTextComponent) {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        boolean bl = false;
        int n3 = jTextComponent.viewToModel(dragGestureEvent.getDragOrigin());
        if (n < n2 && n3 >= n && n3 <= n2) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                Rectangle rectangle2 = jTextComponent.modelToView(n2);
                Rectangle rectangle3 = null;
                if (rectangle.y == rectangle2.y) {
                    rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle2.x - rectangle.x + rectangle2.width, rectangle2.y - rectangle.y + rectangle2.height);
                } else {
                    AccessibleContext accessibleContext = jTextComponent.getAccessibleContext();
                    AccessibleText accessibleText = (AccessibleText)((Object)accessibleContext);
                    rectangle3 = jTextComponent.modelToView(n);
                    for (int i = n + 1; i <= n2; ++i) {
                        Rectangle rectangle4 = accessibleText.getCharacterBounds(i);
                        if (rectangle4 == null) continue;
                        rectangle3.add(rectangle4);
                    }
                }
                this.setOutlineDragImage(rectangle3);
                bl = true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (!bl) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTree jTree) {
        Rectangle rectangle = null;
        int[] nArray = jTree.getSelectionRows();
        for (int i = 0; i < nArray.length; ++i) {
            Rectangle rectangle2 = jTree.getRowBounds(nArray[i]);
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        if (rectangle != null) {
            this.setOutlineDragImage(rectangle);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTable jTable) {
        Rectangle rectangle = null;
        int[] nArray = jTable.getSelectedRows();
        int[] nArray2 = jTable.getSelectedColumns();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                Rectangle rectangle2 = jTable.getCellRect(nArray[i], nArray2[j], true);
                if (rectangle == null) {
                    rectangle = rectangle2;
                    continue;
                }
                rectangle.add(rectangle2);
            }
        }
        if (rectangle != null) {
            this.setOutlineDragImage(rectangle);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JList jList) {
        Rectangle rectangle = null;
        int[] nArray = jList.getSelectedIndices();
        if (nArray.length > 0) {
            rectangle = jList.getCellBounds(nArray[0], nArray[nArray.length - 1]);
        }
        if (rectangle != null) {
            this.setOutlineDragImage(rectangle);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage() {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        this.setOutlineDragImage(new Rectangle(0, 0, component.getWidth(), component.getHeight()), true);
    }

    private void setOutlineDragImage(Rectangle rectangle) {
        this.setOutlineDragImage(rectangle, false);
    }

    private void setOutlineDragImage(Rectangle object, Boolean bl) {
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3 = (int)((Rectangle)object).getWidth();
        int n4 = (int)((Rectangle)object).getHeight();
        double d = 1.0;
        if (bl.booleanValue() && (n2 = n3 * n4) > (n = (int)(fMaxImageSize * fMaxImageSize))) {
            d = (double)n2 / (double)n;
            n3 = (int)((double)n3 / d);
            n4 = (int)((double)n4 / d);
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        Point point = component.getLocation();
        if (component instanceof JComponent) {
            object3 = ((JComponent)component).getVisibleRect();
            object2 = ((Rectangle)object).intersection((Rectangle)object3);
            if (!((Rectangle)object2).isEmpty()) {
                object = object2;
            }
            ((Rectangle)object).translate(point.x, point.y);
        }
        object3 = component.getGraphicsConfiguration();
        object2 = ((GraphicsConfiguration)object3).createCompatibleImage(n3, n4, 3);
        Color color = Color.gray;
        BasicStroke basicStroke = new BasicStroke(2.0f);
        int n5 = (int)(basicStroke.getLineWidth() + 1.0f) / 2;
        Graphics2D graphics2D = (Graphics2D)((BufferedImage)object2).getGraphics();
        graphics2D.setPaint(color);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawRect(n5, n5, n3 - 2 * n5 - 1, n4 - 2 * n5 - 1);
        graphics2D.dispose();
        this.fDragImage = object2;
        Point point2 = dragGestureEvent.getDragOrigin();
        Point point3 = new Point(((Rectangle)object).x - point2.x, ((Rectangle)object).y - point2.y);
        if (component instanceof JComponent) {
            point3.translate(-point.x, -point.y);
        }
        if (bl.booleanValue()) {
            point3.x = (int)((double)point3.x / d);
            point3.y = (int)((double)point3.y / d);
        }
        this.fDragImageOffset = point3;
    }

    private void dragMouseMoved(int n, int n2, final int n3, final int n4) {
        try {
            Component component = LWCToolkit.invokeAndWait(new Callable<Component>(){

                @Override
                public Component call() {
                    LWWindowPeer lWWindowPeer = LWWindowPeer.getWindowUnderCursor();
                    if (lWWindowPeer == null) {
                        return null;
                    }
                    Component component = SwingUtilities.getRoot(lWWindowPeer.getTarget());
                    if (component == null) {
                        return null;
                    }
                    Point point = component.getLocationOnScreen();
                    return CDragSourceContextPeer.getDropTargetAt(component, n3 - point.x, n4 - point.y);
                }
            }, this.getComponent());
            if (component != hoveringComponent) {
                if (hoveringComponent != null) {
                    this.dragExit(n3, n4);
                }
                if (component != null) {
                    this.dragEnter(n, n2, n3, n4);
                }
                hoveringComponent = component;
            }
            this.postDragSourceDragEvent(n, n2, n3, n4, 6);
        }
        catch (Exception exception) {
            throw new InvalidDnDOperationException("Failed to handle DragMouseMoved event");
        }
    }

    private static Component getDropTargetAt(Component component, int n, int n2) {
        if (!(component.contains(n, n2) && component.isEnabled() && component.isVisible())) {
            return null;
        }
        if (component.getDropTarget() != null && component.getDropTarget().isActive()) {
            return component;
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                Point point = component2.getLocation();
                Component component3 = CDragSourceContextPeer.getDropTargetAt(component2, n - point.x, n2 - point.y);
                if (component3 == null) continue;
                return component3;
            }
        }
        return null;
    }

    private void resetHovering() {
        hoveringComponent = null;
    }

    @Override
    protected void setNativeCursor(long l, Cursor cursor, int n) {
        CCursorManager.getInstance().setCursor(cursor);
    }

    private native long createNativeDragSource(Component var1, long var2, Transferable var4, InputEvent var5, int var6, int var7, int var8, int var9, long var10, long var12, int var14, int var15, int var16, long[] var17, Map var18);

    private native void doDragging(long var1);

    private native void releaseNativeDragSource(long var1);

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("apple.awt.dnd.defaultDragImageSize"));
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                if (d > 0.0) {
                    fMaxImageSize = d;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

