/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package javafx.scene.input;

/**
 * Mapping for Button Names
 * @since JavaFX 2.0
 */
public enum MouseButton {

    /**
     * Represents no button.
     */
    NONE,

    /**
     * Represents primary (button 1, usually the left) mouse button.
     */
    PRIMARY,

    /**
     * Represents middle (button 2) mouse button.
     */
    MIDDLE,

    /**
     * Represents seconday (button 3, usually the right) mouse button.
     */
    SECONDARY,
}
